@extends('layouts.master')

<?php
use App\Http\Controllers\UserController;
?>

@section('content')


    <main class="contentContainer">

        <h1>Projekte @if(isset($preFilteredByCustomer) && $preFilteredByCustomer==true)
                von {{ $preFilteredCustomer }}@endif</h1>

        @if(UserController::checkRight("createOrders", $user))
            <a class="button" style="width: 400px; text-align: center; position:absolute;top:25px;right:10px;"
               href="{{ route('projects.create') }}">Neues Projekt anlegen</a>
        @endif


        @include('project.listSection')


        <script>
            let listType = "ordersList";

            $(document).ready(function(){
                setTimeout(checkPendingProjects, 1000);
            });

            function checkPendingProjects()
            {
                $('.listItem[data-loading="true"]').each(function(){
                    // debugger;
                    var projectItem = this;
                    $.get("/checkProjectStatus/" + $(this).data("projectid"), function(data, status) {
                        var projectJsonData = JSON.parse(data);
                        if(projectJsonData.status == "created")
                        {
                            $(projectItem).data("loading","");
                            $('[data-projectid="' + projectJsonData.id + '"] .loading-gif').slideUp();
                            $('[data-projectid="' + projectJsonData.id + '"] .actions').fadeIn();
                        }
                    });
                });

                setTimeout(checkPendingProjects, 1000);
            }

        </script>


@endsection
