@extends('layouts.master')
<?php
use App\Library\DropzoneMulti;
use App\Http\Controllers\UserController;
use App\User;

$dropzoneOptions = [
    'acceptedFiles' => '"image/*,application/pdf,application/msword,application/vnd.ms-powerpoint,application/vnd.ms-excel,.xlsx,.xls,.doc,.docx,.ppt,.pptx,.msg"',
    'maxFilesize' => 15,
    'maxFiles' => 15
];


$projectDocumentDropzone = new DropzoneMulti(
    $dropzoneOptions,
    "editProjectType",
    "editProjectTypeProjectDocumentsDropzone",
    "default", true, "fas fa-file",
    "newProjectFiles"
);

$articleDocumentDropzone = new DropzoneMulti(
    $dropzoneOptions,
    "editProjectType",
    "editProjectTypeArticleDocumentsDropzone",
    "default", true, "fas fa-file",
    "newArticleFiles"
);

?>

@section('content')
    <main class="contentContainer">

        <h1>Projekttyp bearbeiten</h1>

        <button type="button" class="btn btn-primary btn-big editProjectTypeSubmit"
                style="position: absolute; right: 10px; top: 10px;">
            Projekttyp speichern
        </button>

        {!! BootForm::open(["id" => "editProjectType",
                             "route" => "projectTypes.update",
                             "method" => "POST",
                             "enctype" => "multipart/form-data"]);
                             !!}

        <input type="hidden" name="projectTypeToEdit" value="{{ $projectType->id }}">


        <div class="row no-gutters listHeader">
            <div class="col-12">Grunddaten</div>
        </div>
        <div class="row">
            <div class="col-12">
                <br>
                <h3>Bezeichnung Projekttyp</h3>
                <input class="form-control" value="{{$projectType->title}}" name="title"/>
                <br><br>

            </div>
        </div>

        {{-- Liste für die via Dropzone hochgeladenen Files --}}
        <div id="newFileContainerList">
            <input type="hidden" id="documentFileFields" name="documentFileFields" value='{ "fields" : [] }'>
            <input type="hidden" id="newProjectFiles" name="newProjectFiles" value='{ "files": [], "fileSizes": [] }'>
            <input type="hidden" id="newArticleFiles" name="newArticleFiles" value='{ "files": [], "fileSizes": [] }'>
        </div>

        {!! BootForm::close() !!}

        <h3>Projektspezifische Templates / Dokumente</h3>
        @include('document.documentList', array('dropzone' => $projectDocumentDropzone, 'documentList' => $projectTypeProjectDocumentList))
        <br>
        <h3>Artikelspezifische Templates / Dokumente</h3>
        @include('document.documentList', array('dropzone' => $articleDocumentDropzone, 'documentList' => $projectTypeArticleDocumentList))



    </main>

    @include('layouts.overlay')



    <script>

        jQuery(".editProjectTypeSubmit").click(function () {
            showLoadingSpinner();
            jQuery("#editProjectType").submit();
        });

        // Neuen Logeintrag verarbeiten
        jQuery(document).on('click', 'button#addOrderLog', function () {

            // Eingabe validieren
            if (!jQuery("form#addOrderLog").valid()) {
                showModalBox("Validierungsfehler", "")
                return;
            }

            // Daten für einen neuen Log aus dem Overlay holen und im JSON-Objekt speichern
            let newLog = {};
            newLog.operator_id = jQuery("input[name=operatorID]").val();
            newLog.operatorLabel = jQuery("input[name=operatorLabel]").val();
            newLog.order_id = jQuery("input[name=orderID]").val();
            newLog.text = jQuery("textarea#text").val();

            // Bisherige neu hinzugefügte Logs holen
            let jsonLogs = jQuery("input#newLogEntries").val();
            let logs = JSON.parse(jsonLogs);

            logs.logs.push(newLog);

            let newLogs = JSON.stringify(logs);

            // JSON-String in unsichtbarem Input hinzufügen
            jQuery("input#newLogEntries").val(newLogs);

            // Neue Log-Nachricht vorblenden
            let newLogListItem = '<div class="row no-gutters listItem userlog">\n' +
                '                            <div class="col-9">\n' +
                newLog.text +
                '                            </div>\n' +
                '                            <div class="col-2">\n' +
                newLog.operatorLabel +
                '                            </div>\n' +
                '                            <div class="col-1">\n' +
                '                                gerade eben \n' +
                '                            </div>\n' +
                '                        </div>';

            jQuery("#closeListEditor").trigger("click");

            jQuery("#logEntries #noListEntries").fadeOut();

            jQuery("#logEntries").prepend(newLogListItem);
        });

        // Neue Auftrags-Email versenden und in Liste vorblenden
        jQuery(document).on('click', 'button#createOrderMail', function () {

            // Daten für eine neue Auftragsmail aus dem Overlay holen
            let newMail = {};
            newMail.operator_id = jQuery("input[name=operatorID]").val();
            newMail.order_id = jQuery("input[name=orderID]").val();
            newMail.to = jQuery("input[name=to]").val();
            newMail.subject = jQuery("input[name=subject]").val();
            newMail.text = jQuery("textarea#text").val();

            // Anhänge bzw. deren Pfade holen
            newMail.attachments = [];
            jQuery("input[data-orderDocumentPath]:checked").each(function () {
                newMail.attachments.push(jQuery(this).data("orderdocumentpath"));
            });

            // Für Vorblendung in Liste
            newMail.operatorLabel = jQuery("input[name=operatorLabel]").val();
            newMail.messageExcerpt = newMail.text.substring(0, 50) + "...";

            // AJAX-Request zum Versenden der E-Mail starten
            // Ajax-Parameter festlegen
            var url = '/ordermail/send';
            var data = {};
            data["newMail"] = JSON.stringify(newMail);

            // Handling für erfolgreichen Request
            successFunction = function (response) {
                if (response.response == "success") {

                    // Erfolgsmeldung anzeigen
                    jQuery("#loadingSpinner").hide();
                    showModalBox("E-Mail erstellt", "Die E-Mail wurde im System  hinterlegt und wird demnächst versendet.");
                    jQuery("#listEditor").removeClass();
                    jQuery("#listOverlay").hide();

                    jQuery("#mailEntries #noListEntries").fadeOut();

                    // E-Mail in Historie vorblenden

                    let newMailLogEntry = ' <div class="row no-gutters listItem">\n' +
                        '                                        <div class="col-3">\n' +
                        '                                           <div class="row no-gutters label">\n' +
                        '                                               ' + newMail.subject + '<br>\n' +
                        '                                           </div>\n' +
                        '                                           <div class="row no-gutters">\n' +
                        '                                               ' + newMail.to + '\n' +
                        '                                           </div>\n' +
                        '                                        </div>\n' +
                        '                                        <div class="col-5" style="word-break: break-word; padding-right: 10px;">\n' +
                        '                                            ' + newMail.messageExcerpt + '\n' +
                        '                                        </div>\n' +
                        '                                        <div class="col-2">\n' +
                        '                                            ' + newMail.operatorLabel + '\n' +
                        '                                        </div>\n' +
                        '                                        <div class="col-2">\n' +
                        '                                            demnächst \n' +
                        '                                        </div>\n' +
                        '                                    </div>';


                    jQuery("#mailEntries").prepend(newMailLogEntry);
                } else {
                    errorFunction(response);
                }
                hideOverlayLoadingSpinner();
            };

            // Handling für fehlerhaften Request
            errorFunction = function (response) {
                showOverlayAlert(response.message);

                hideOverlayLoadingSpinner();
            };

            // Ajax aufrufen
            fireAjax(url, data, successFunction, errorFunction);
        });

        // Auftragsdokument sichern/entsperren
        jQuery(document).on('click', '.specialtogglelock', function () {

            showLoadingSpinner();
            let currentClass = jQuery(this).find("i").attr('class');
            let documentid =  jQuery(this).data("orderdocument");
            let newLockState = 0;
            if(currentClass == "fas fa-lock-open-alt")
            {
                // Sichern
                jQuery(this).find("i").removeClass("fa-lock-open-alt").addClass("fas fa-lock-alt");
                newLockState = 1;
            }
            else if(currentClass == "fas fa-lock-alt")
            {
                // Entsichern
                jQuery(this).find("i").removeClass("fa-lock-alt").addClass("fas fa-lock-open-alt");
            }

            // AJAX-Request zum Versenden der E-Mail starten
            // Ajax-Parameter festlegen
            var url = '/orderdocuments/lock';
            var data = {};
            data["documentid"] = documentid;
            data["newLockState"] = newLockState;

            // Handling für erfolgreichen Request
            successFunction = function (response) {
                if (response.response == "success") {

                    // Erfolgsmeldung anzeigen
                    hideLoadingSpinner();
                    if(newLockState == 1)
                    {
                        $description = "Die Datei kann nur noch vom Eigentümer oder berechtigten Personen eingesehen werden.";
                        showModalBox("Das Dokument wurde erfolgreich gesichert.", $description);
                    }
                    else {
                        showModalBox("Das Dokument wurde entsperrt.", "");
                    }
                } else {
                    errorFunction(response);
                }
            };

            // Handling für fehlerhaften Request
            errorFunction = function (response) {
                showModalBox("Es ist ein Fehler aufgetreten.", response.message);
                hideLoadingSpinner();
            };

            // Ajax aufrufen
            fireAjax(url, data, successFunction, errorFunction);
        });

        // Duplikatsprüfung
        jQuery(".additionalOrderSubmit").click(function () {
            showLoadingSpinner();

            let url = "/orders/duplicate";

            // Ajax-Request für das Nachladen des Overlay-Forms vorbereiten
            var token = jQuery('meta[name="csrf-token"]').attr('content');
            jQuery.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': token
                }
            });

            $.post(url, jQuery("#editProject").serialize(), function (data) {

                if (data.response == "error") {
                    jQuery("#loadingSpinner").hide();
                    jQuery("#editorContent").html(data.editorHTML);
                    jQuery("#listEditor").addClass("windowNarrow");
                    jQuery("#listEditor").fadeIn();
                }
                else {
                    if (data.response != "duplicateExists")
                    {
                        jQuery("#editProject").submit();
                        hideLoadingSpinner();
                    }
                    else
                    {
                        jQuery("#loadingSpinner").hide();
                        jQuery("#editorContent").html(data.editorHTML);
                        jQuery("#listEditor").addClass("windowNarrow");
                        jQuery("#listEditor").fadeIn();
                    }
                }
            });
        });

    </script>
@endsection
