@extends('layouts.master')

@section('content')
    <main class="contentContainer">
        <h1>Neuen Mandanten anlegen</h1>

        <p>Hier kann ein neuer Mandant angelegt werden. Nach Ausfüllen des Formulars erhält eine Kontaktperson bei
            diesem
            Mandant einen Link, um die Daten des Mandanten zu vervollständigen und den ersten Mandantenadministrator
            anzulegen.
            Sobald dieser Prozess abgeschlossen ist, wird der Mandant aktiviert und ist im System sichtbar.</p>

        <p>&nbsp;</p>

        {!!BootForm::open(["id" => "newClient",
                           "route" => array('superAdmin.handleRegisterClientForm'),
                           "method" => "POST"
                           ])!!}

        <div class="row">
            <div class="col-md-8 col-xs-12">

                <div class="form-group row">
                    <label for="clientName" class="col-sm-2 col-form-label">Name des Mandanten</label>
                    <div class="col-sm-10">
                        <input type="text" class="form-control" name="name" id="clientName">
                    </div>
                </div>
                <div class="form-group row">
                    <label for="emailAddress" class="col-sm-2 col-form-label" aria-describedby="emailHelpBlock">E-Mail-Adresse</label>
                    <div class="col-sm-10">
                        <input type="email" class="form-control" name="email" id="emailAddress">
                        <small id="emailHelpBlock" class="form-text text-muted">
                            An diese E-Mail-Adresse wird der Link zum Vervollständigen der Mandantendaten und zum
                            Anlegen
                            des ersten Mandantenadmins versendet.
                        </small>
                    </div>
                </div>

                <div class="form-group row">
                    <label for="emailAddressConfirm" class="col-sm-2 col-form-label">E-Mail-Adresse bestätigen</label>
                    <div class="col-sm-10">
                        <input type="email" class="form-control" name="emailAddressConfirm" id="emailAddressConfirm">
                    </div>
                </div>

                <div class="form-group row mb-0">
                    <div class="col-md-8 offset-md-4 text-md-right">
                        <button type="submit" class="btn btn-primary btn-big">
                            Registrieren
                        </button>
                    </div>
                </div>
            </div>
        </div>


        {!! BootForm::close() !!}

    </main>
@endsection
