<?php

use App\Http\Controllers\UserController;

if ($variable->id == NULL) $mode = "create";
else $mode = "edit";

?>

<header>Variable @if($mode=="create") anlegen @elseif($mode=="edit") bearbeiten @endif</header>


<div class="container">
    @if($mode=="create")
        {!! BootForm::open(["id" => "editVariable",
                             "route" => "variables.store",
                             "method" => "POST",
                             "enctype" => "multipart/form-data"]);
                             !!}
    @elseif($mode=="edit")
        {!! BootForm::open(["id" => "editVariable",
                             "route" => array("articleVariables.update", $variable->id),
                             "method" => "POST",
                             "enctype" => "multipart/form-data"]);
                             !!}
    @endif

    <input type="hidden" name="ref_type" value="{{$variable->ref_type}}">
    <input type="hidden" name="variableId" value="{{$variable->id}}">
    <div class="form-group row">
        <label for="label" class="col-12 col-lg-4 col-form-label">Bezeichnung</label>
        <div class="col-12 col-lg-8 mb-2">
            <input type="text" class="form-control" id="title" name="title"
                   value="{{ $variable->title }}">
        </div>
        <label for="label" class="col-12 col-lg-4 col-form-label">Bez. in Dokument</label>
        <div class="col-12 col-lg-8 mb-2">
            <input type="text" class="form-control" id="variable_title" name="variable_title"
                   value="{{ $variable->variable_title }}">
        </div>
        <label for="label" class="col-12 col-lg-4 col-form-label">Variablentyp</label>
        <div class="col-12 col-lg-8 mb-2">
            <select class="form-control" id="variable_type" name="variable_type"
                   value="{{ $variable->variable_type }}">
                <option value="value">Wert / Text</option>
                <option value="image">Bild</option>
            </select>
        </div>
    </div>

</div>

<footer>
    <div class="form-group row align-items-center">
        <div class="col-6 text-left">
            <button type="button" id="closeListEditorButton" class="btn btn-secondary">
                Abbrechen
            </button>
        </div>

        <div class="col-6 text-right">
            <button type="submit" form="editVariable" class="btn btn-primary">
                Speichern
            </button>
        </div>
    </div>
</footer>


{!! BootForm::close() !!}


{{--    Der JSValidator muss hier extra eingebaut werden, da Template asynchron geholt wird und der Code im Header-Bereich
        nicht generiert wird --}}
@if(isset($validator))
    <script type="text/javascript" src="{{ asset('vendor/jsvalidation/js/jsvalidation.js')}}"></script>
    @if (is_array($validator))
        @foreach($validator as $vali)
            {!! $vali !!}
        @endforeach
    @else
        {!! $validator !!}
    @endif
@endif
<script>
    jQuery(document).ready(function(){
        jQuery('#title').keyup(function(){
            jQuery('#variable_title').val(jQuery('#title').val().toLowerCase().split(' ').join('_'));
        });
    });
</script>