@extends('layouts.master')

<?php
use App\Http\Controllers\UserController;
?>

@section('content')
    <main class="contentContainer">

        <h1>Projektvariablen</h1>
        <div class="row">
            <div class="col-12 col-md-3 text-md-center">
                @if(UserController::checkRight("createVariable", $user))
                    <a class="button editVariable"
                       href="#"
                       data-variableid="0">Neue Projektvariable anlegen</a>
                @endif
            </div>
{{--            <div class="col-12 col-md-3 text-md-center">--}}
{{--                <div id="article-variable-button"></div>--}}
{{--            </div>--}}
        </div>

        <div class="clearfix">&nbsp;</div>

        <div class="row no-gutters" data-itable='1'>
            <div class="col-12">
                <div class="row no-gutters listHeader">
                    <div class="col-4">
                        Bezeichnung
                    </div>
                    <div class="col-4">
                        Bezeichnung im Dokument
                    </div>
                    <div class="col-2">
                        Variablentyp
                    </div>
                    <div class="col-2">
                        Aktionen
                    </div>
                </div>
                <div class="listBody">
                @if(count($variableList) > 0)
                    @foreach($variableList as $variable)
                        <div class="row no-gutters align-items-center listItem">

                            <div class="col-4 label">
                                {{ $variable->title }}
                            </div>

                            <div class="col-4">
                                {{ $variable->variable_title }}
                            </div>

                            <div class="col-2">
                                {{ $variable->type }}
                            </div>

                            <div class="col-2">
                                <div class="row no-gutters">
                                    <div class="">
                                        @if(UserController::checkRight("editVariable", $user))
                                            <a href="#"
                                               data-variableid="{{ $variable->id }}"
                                               class="editVariable"
                                               title="Bearbeiten">
                                                <i class="fal fa-pencil-alt"></i>
                                            </a>
                                        @endif
                                    </div>

                                    <div class="">
                                        @if(UserController::checkRight("deleteVariable", $user))
                                            <a href="#"
                                               data-variableid="{{ $variable->id }}"
                                               class="deleteVariable"
                                               title="Löschen">
                                                <i class="fal fa-trash-alt"></i>
                                            </a>
                                        @endif
                                    </div>

                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
                @else
                    <div id="noListEntries" class="row">
                        <div class="col-12 text-center">
                            Keine Variablen für Projekte hinterlegt.
                        </div>
                    </div>
                @endif
            </div>
        </div>
    </main>
    <div id="article-variable">

    </div>
    @include('layouts.overlay')


    <script>

        jQuery(function () {
            // Variable anlegen/bearbeiten: Overlay öffnen
            jQuery(".editVariable").click(function () {
                showLoadingSpinner();

                // Ajax-Parameter festlegen
                var url = '/variable';
                var data = {};
                data["variableId"] = jQuery(this).data("variableid");
                data["ref_type"] = "project";

                // Handling für erfolgreichen Request
                successFunction = function (response) {
                    if (response.response == "success") {
                        jQuery("#loadingSpinner").hide();
                        jQuery("#editorContent").html(response.editorHTML);
                        jQuery("#listEditor").addClass("windowNarrow");
                        jQuery("#listEditor").fadeIn();
                    }
                    else {
                        errorFunction(response);
                    }
                };

                // Handling für fehlerhaften Request
                errorFunction = function (response) {
                    showModalBox("Es ist ein Fehler aufgetreten.", response.message);
                    hideLoadingSpinner();
                };

                // Ajax aufrufen
                fireAjax(url, data, successFunction, errorFunction);
            });


            // Auftragstyp löschen: Overlay öffnen
            jQuery(".deleteVariable").click(function () {
                showLoadingSpinner();

                // Ajax-Parameter festlegen
                var url = '/conf/variables/deleteConfirm';
                var data = {};
                data["variableId"] = jQuery(this).data("variableid");

                // Handling für erfolgreichen Request
                successFunction = function (response) {
                    if (response.response == "success") {
                        jQuery("#loadingSpinner").hide();
                        jQuery("#editorContent").html(response.editorHTML);
                        jQuery("#listEditor").addClass("windowModal");
                        jQuery("#listEditor").fadeIn();
                    }
                    else {
                        errorFunction(response);
                    }
                };

                // Handling für fehlerhaften Request
                errorFunction = function (response) {
                    showModalBox("Es ist ein Fehler aufgetreten.", response.message);
                    hideLoadingSpinner();
                };

                // Ajax aufrufen
                fireAjax(url, data, successFunction, errorFunction);

            });

        });
    </script>


@endsection
