<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::group(['middleware' => ['auth']], function () {

//    Route::get('/home', ['as' => 'index', 'uses' => 'HomeController@index']);
    Route::get('/home', ['as' => 'index', 'uses' => 'ProjectsController@index']);


    /* KTKMouldtec */

    # Projekte
    Route::get('/projects/{customerId?}', ['as' => 'projects.list', 'uses' => 'ProjectsController@index']);
    Route::post('/projects/search', ['as' => 'projects.asyncSearch', 'uses' => 'ProjectsController@asyncSearch']);

    Route::get('/project/newProject',['as' => 'projects.create', 'uses' => 'ProjectsController@create']);
    Route::post('/project/newProject', ['as' => 'projects.store', 'uses' => 'ProjectsController@store']);
    Route::post('projectArticles/newProject', ['as' => 'projectArticleVariables.store', 'uses' => 'ProjectsController@storeArticles']);
    Route::get('/project/{projectId}', ['as' => 'projects.edit', 'uses' => 'ProjectsController@edit']);
    Route::post('/project', ['as' => 'projects.update', 'uses' => 'ProjectsController@update']);

    Route::get('/projectArticles/newProject/{projectId}', ['as' => 'projectArticles.create', 'uses' => 'ProjectsController@createArticle']);

    Route::post('/projects/deleteConfirm', ['as' => 'projects.deleteConfirm', 'uses' => 'ProjectsController@showDeleteConfirm']);
    Route::post('/projects/delete', ['as' => 'projects.delete', 'uses' => 'ProjectsController@destroy']);

    Route::get('/checkProjectStatus/{projectId}', ['as' => 'project.checkStatus', 'uses' => 'ProjectsController@checkStatus']);


    # Konfiguration Projekte
    ## Projekttyp
    Route::get('/conf/projecttypes', ['as' => 'projectTypes.list', 'uses' => 'ProjectTypesController@index']);
    Route::post('/conf/projecttype', ['as' => 'projectTypes.edit', 'uses' => 'ProjectTypesController@edit']);
    Route::post('/conf/projecttypes/new', ['as' => 'projectTypes.store', 'uses' => 'ProjectTypesController@store']);
    Route::post('/conf/projecttypes/edit', ['as' => 'projectTypes.update', 'uses' => 'ProjectTypesController@update']);
    Route::post('/conf/projecttypes/deleteConfirm', ['as' => 'projectTypes.deleteConfirm', 'uses' => 'ProjectTypesController@showDeleteConfirm']);
    Route::post('/conf/projecttypes/delete', ['as' => 'projectTypes.delete', 'uses' => 'ProjectTypesController@destroy']);

    Route::get('/projecttype/{projectTypeId}', ['as' => 'projectTypes.editPage', 'uses' => 'ProjectTypesController@editPage']);

    # Operating Instruction (Arbeitsanweisung)
    Route::get('/operatinginstructions', ['as' => 'operatinginstructions.list', 'uses' => 'OperatingInstructionsController@index']);
    Route::post('/operatinginstruction', ['as' => 'operatinginstructions.edit', 'uses' => 'OperatingInstructionsController@edit']);
    Route::post('/operatinginstruction/new', ['as' => 'operatinginstructions.store', 'uses' => 'OperatingInstructionsController@store']);
    Route::post('/operatinginstruction/edit/{operatingInstructionId}', ['as' => 'operatinginstructions.update', 'uses' => 'OperatingInstructionsController@update']);
    Route::post('/operatinginstruction/deleteConfirm', ['as' => 'operationinstructions.deleteConfirm', 'uses' => 'OperatingInstructionsController@showDeleteConfirm']);
    Route::post('/operatinginstruction/delete', ['as' => 'operationInstructions.delete', 'uses' => 'OperatingInstructionsController@destroy']);

    # Procedural Instruction (Verfahrensanweisung)
    Route::get('/proceduralinstructions', ['as' => 'proceduralinstructions.list', 'uses' => 'ProceduralInstructionsController@index']);
    Route::post('/proceduralinstruction', ['as' => 'proceduralinstructions.edit', 'uses' => 'ProceduralInstructionsController@edit']);
    Route::post('/proceduralinstruction/new', ['as' => 'proceduralinstructions.store', 'uses' => 'ProceduralInstructionsController@store']);
    Route::post('/proceduralinstruction/edit/{proceduralInstructionId}', ['as' => 'proceduralinstructions.update', 'uses' => 'ProceduralInstructionsController@update']);
    Route::post('/proceduralinstruction/deleteConfirm', ['as' => 'proceduralinstructions.deleteConfirm', 'uses' => 'ProceduralInstructionsController@showDeleteConfirm']);
    Route::post('/proceduralinstruction/delete', ['as' => 'proceduralInstructions.delete', 'uses' => 'ProceduralInstructionsController@destroy']);


    # Variables
    Route::get('/articleVariables', ['as' => 'articleVariables.list', 'uses' => 'VariablesController@indexArticleVariables']);
    Route::post('/articleVariables/edit', ['as' => 'articleVariables.update', 'uses' => 'VariablesController@update']);
    Route::get('/projectVariables', ['as' => 'projectVariables.list', 'uses' => 'VariablesController@indexProjectVariables']);
    Route::post('/variable', ['as' => 'variable.edit', 'uses' => 'VariablesController@edit']);
    Route::post('/variables', ['as' => 'variables.store', 'uses' => 'VariablesController@store']);

    Route::post('/conf/variables/deleteConfirm', ['as' => 'variables.deleteConfirm', 'uses' => 'VariablesController@showDeleteConfirm']);
    Route::post('/conf/variables/delete', ['as' => 'variables.delete', 'uses' => 'VariablesController@destroy']);

    # Documents
    Route::get('/downloadDocumentRevision/{documentRevisionId}', ['as' => 'download.documentRevision', 'uses' => 'DocumentController@downloadDocumentRevision']);
    Route::get('/downloadTmpFile/{tmpFile}', ['as' => 'download.tmpfile', 'uses' => 'DocumentController@downloadTmpFile']);

    # Messages
    Route::get('/checkMessages', ['as' => 'message.check', 'uses' => 'MessageController@checkAndGetMessage']);

    /* KTKMouldtec (END) */

    # User: E-Mail-Adresse ändern
    Route::get('/user/edit/changeEmail', ['as' => 'user.changeEmail', 'uses' => 'UserController@changeEmail']);
    Route::post('/user/edit/changeEmail', ['as' => 'user.changeEmailSent', 'uses' => 'UserController@changeEmailSent']);
    Route::get('/user/edit/changeEmailCheckConfirmation/{token}', ['as' => 'user.changeEmailCheckConfirmation', 'uses' => 'UserController@changeEmailCheckConfirmation']);
    Route::get('/user/edit/changeEmailChanged/{token}', ['as' => 'user.changeEmailChanged', 'uses' => 'UserController@changeEmailChanged']);

    # User editieren
    Route::get('/user/edit', ['as' => 'user.edit', 'uses' => 'UserController@edit']);
    Route::post('/user/edit/update/{id}', ['as' => 'user.edit.update', 'uses' => 'UserController@update']);

    # User: Passwort zurücksetzen
    Route::get('/user/edit/userSecurity', ['as' => 'user.userSecurity', 'uses' => 'UserController@userSecurity']);
    Route::get('/user/edit/passwordReset', ['as' => 'user.passwordReset', 'uses' => 'UserController@callPasswordReset']);

    # Userliste
    Route::get('/users', ['as' => 'user.list', 'uses' => 'UserController@showList']);

    # Mandantenadministrator
    Route::get('/clientadmin/users', ['as' => 'clientAdmin.users', 'uses' => 'ClientAdminController@showUserList']);
    Route::post('/clientadmin/userRightsEdit', ['as' => 'clientAdmin.userRightsEdit', 'uses' => 'ClientAdminController@showUserRightsEdit']);
    Route::post('/clientadmin/changeUserRights', ['as' => 'clientAdmin.changeUserRights', 'uses' => 'ClientAdminController@changeUserRights']);
    Route::post('/clientadmin/userEdit', ['as' => 'clientAdmin.userEdit', 'uses' => 'ClientAdminController@showUserEdit']);
    Route::get('/clientadmin/newUser/{operatorId?}', ['as' => 'clientAdmin.newUser', 'uses' => 'ClientAdminController@showUserRegister']);
    Route::post('/clientadmin/newUserRegister', ['as' => 'clientAdmin.newUserRegister', 'uses' => 'ClientAdminController@registerNewUser']);
    Route::post('/clientadmin/userDelete', ['as' => 'clientAdmin.showUserDelete', 'uses' => 'ClientAdminController@showUserDelete']);
    Route::post('/clientadmin/deleteUser', ['as' => 'clientAdmin.deleteUser', 'uses' => 'ClientAdminController@deleteUser']);
    Route::get('/clientadmin/resetUserPassword/{userID}', ['as' => 'clientAdmin.resetUserPassword', 'uses' => 'ClientAdminController@resetUserPassword']);

    # Registrierung neuer Mandant
    Route::get('/superadmin/newClient', ['as' => 'superAdmin.newClient', 'uses' => 'SuperAdminController@showRegisterClient']);
    Route::post('/superadmin/newClient', ['as' => 'superAdmin.handleRegisterClientForm', 'uses' => 'SuperAdminController@handleRegisterClientForm']);
    Route::get('/client/newClient/complete/{token}', ['as' => 'client.confirmClientAdmin', 'uses' => 'ClientController@confirmClientAdmin']);
    Route::get('/client/edit/{client_id?}', ['as' => 'client.edit', 'uses' => 'ClientController@edit']);

    # Bearbeiten Stammdaten Mandant
    Route::post('/client/update', ['as' => 'client.update', 'uses' => 'ClientController@updateClient']);

    # Hochladen temporärer Dateien über Dropzones
    Route::post('/dropzone/uploadTemporaryFile', ['as' => 'dropzone.uploadTemporaryFile', 'uses' => 'DropzoneController@uploadTemporaryFile']);
//
//
//    # Bearbeiter
    Route::get('/operators', ['as' => 'operator.list', 'uses' => 'OperatorController@index']);
    Route::get('/operator/{operatorId}', ['as' => 'operator.edit', 'uses' => 'OperatorController@edit']);
    #Route::post('/operator', ['as' => 'operator.edit', 'uses' => 'OperatorController@edit']);
    Route::post('/operator/new', ['as' => 'operator.store', 'uses' => 'OperatorController@store']);
    Route::post('/operator/edit', ['as' => 'operator.update', 'uses' => 'OperatorController@update']);
    Route::get('/operator/newUserConfirm/{operatorId}', ['as' => 'operator.newUserConfirm', 'uses' => 'OperatorController@showUserRegisterConfirm']);
    # Route::post('/operator/edit/{operatorId}', ['as' => 'operator.update', 'uses' => 'OperatorController@update']);
    Route::get('/searchOperator/{search?}', ['as' => 'operator.asyncSearch', 'uses' => 'OperatorController@asyncSearch']);
//
//
//    # Kunden
    Route::get('/customers', ['as' => 'customer.list', 'uses' => 'CustomerController@index']);
    Route::get('/customer/{customerId}', ['as' => 'customer.edit', 'uses' => 'CustomerController@edit']);
    #Route::post('/customer/', ['as' => 'customer.edit', 'uses' => 'CustomerController@edit']);
    Route::post('/customer/new', ['as' => 'customer.store', 'uses' => 'CustomerController@store']);
    #Route::post('/customer/edit/{customerId}', ['as' => 'customer.update', 'uses' => 'CustomerController@update']);
    Route::post('/customer/edit', ['as' => 'customer.update', 'uses' => 'CustomerController@update']);
    Route::get('/customer/delete/{customerId}', ['as' => 'customer.delete', 'uses' => 'CustomerController@destroy']);
    Route::get('/searchCustomer/{search?}', ['as' => 'customer.asyncSearch', 'uses' => 'CustomerController@asyncSearch']);
//
//
//    # Aufträge
//    Route::get('/orders/{customerId?}', ['as' => 'orders.list', 'uses' => 'OrdersController@index']);
//    Route::get('/order/newOrder', ['as' => 'orders.create', 'uses' => 'OrdersController@create']);
//    Route::post('/order/newOrder', ['as' => 'orders.store', 'uses' => 'OrdersController@store']);
//    Route::get('/order/{orderId}', ['as' => 'orders.edit', 'uses' => 'OrdersController@edit']);
//    Route::post('/order', ['as' => 'orders.update', 'uses' => 'OrdersController@update']);
//
//    Route::post('/orders/deleteConfirm', ['as' => 'orders.deleteConfirm', 'uses' => 'OrdersController@showDeleteConfirm']);
//    Route::post('/orders/delete', ['as' => 'orders.delete', 'uses' => 'OrdersController@destroy']);
//
//    Route::post('/orders/search', ['as' => 'orders.asyncSearch', 'uses' => 'OrdersController@asyncSearch']);
//
//    Route::get('/orders/copy/{orderId}', ['as' => 'orders.clone', 'uses' => 'OrdersController@clone']);
//
//    Route::get('/orders/datasheet/{orderId}', ['as' => 'orders.datasheet', 'uses' => 'OrdersController@makeDatasheetPdf']);
//
    Route::post('/orders/duplicate', ['as' => 'orders.duplicate', 'uses' => 'OrdersController@checkDuplicate']);
//
//    # Konfiguration Aufträge
//    ## Auftragstyp
//    Route::get('/conf/ordertypes', ['as' => 'orderTypes.list', 'uses' => 'OrderTypesController@index']);
//    Route::post('/conf/ordertype', ['as' => 'orderTypes.edit', 'uses' => 'OrderTypesController@edit']);
//    Route::post('/conf/ordertypes/new', ['as' => 'orderTypes.store', 'uses' => 'OrderTypesController@store']);
//    Route::post('/conf/ordertypes/edit/{orderTypeId}', ['as' => 'orderTypes.update', 'uses' => 'OrderTypesController@update']);
//    Route::post('/conf/ordertypes/deleteConfirm', ['as' => 'orderTypes.deleteConfirm', 'uses' => 'OrderTypesController@showDeleteConfirm']);
//    Route::post('/conf/ordertypes/delete', ['as' => 'orderTypes.delete', 'uses' => 'OrderTypesController@destroy']);
//
//    ## Auftragskennzeichen
//    Route::get('/conf/ordertags', ['as' => 'orderTags.list', 'uses' => 'OrderTagsController@index']);
//    Route::post('/conf/ordertag', ['as' => 'orderTags.edit', 'uses' => 'OrderTagsController@edit']);
//    Route::post('/conf/ordertags/new', ['as' => 'orderTags.store', 'uses' => 'OrderTagsController@store']);
//    Route::post('/conf/ordertags/edit/{orderTagId}', ['as' => 'orderTags.update', 'uses' => 'OrderTagsController@update']);
//    Route::post('/conf/ordertags/deleteConfirm', ['as' => 'orderTags.deleteConfirm', 'uses' => 'OrderTagsController@showDeleteConfirm']);
//    Route::post('/conf/ordertags/delete', ['as' => 'orderTags.delete', 'uses' => 'OrderTagsController@destroy']);
//
//    ## Auftragsstatus
//    Route::get('/conf/orderstatusList', ['as' => 'orderStatus.list', 'uses' => 'OrderStatusController@index']);
//    Route::post('/conf/orderstatus', ['as' => 'orderStatus.edit', 'uses' => 'OrderStatusController@edit']);
//    Route::post('/conf/orderstatus/new', ['as' => 'orderStatus.store', 'uses' => 'OrderStatusController@store']);
//    Route::post('/conf/orderstatus/edit/{orderStatusId}', ['as' => 'orderStatus.update', 'uses' => 'OrderStatusController@update']);
//    Route::post('/conf/orderstatus/deleteConfirm', ['as' => 'orderStatus.deleteConfirm', 'uses' => 'OrderStatusController@showDeleteConfirm']);
//    Route::post('/conf/orderstatus/delete', ['as' => 'orderStatus.delete', 'uses' => 'OrderStatusController@destroy']);
//
//    ## Zahlstatus
//    Route::get('/conf/paymentstatusList', ['as' => 'orderPaymentStatus.list', 'uses' => 'OrderPaymentStatusController@index']);
//    Route::post('/conf/paymentstatus', ['as' => 'orderPaymentStatus.edit', 'uses' => 'OrderPaymentStatusController@edit']);
//    Route::post('/conf/paymentstatus/new', ['as' => 'orderPaymentStatus.store', 'uses' => 'OrderPaymentStatusController@store']);
//    Route::post('/conf/paymentstatus/edit/{orderPaymentStatusId}', ['as' => 'orderPaymentStatus.update', 'uses' => 'OrderPaymentStatusController@update']);
//    Route::post('/conf/paymentstatus/deleteConfirm', ['as' => 'orderPaymentStatus.deleteConfirm', 'uses' => 'OrderPaymentStatusController@showDeleteConfirm']);
//    Route::post('/conf/paymentstatus/delete', ['as' => 'orderPaymentStatus.delete', 'uses' => 'OrderPaymentStatusController@destroy']);
//
//    ## Textbausteine
//    Route::get('/conf/textblocks', ['as' => 'textblocks.list', 'uses' => 'TextblockController@index']);
//    Route::get('/conf/textblock/{textblockId}', ['as' => 'textblocks.edit', 'uses' => 'TextblockController@edit']);
//    Route::post('/conf/textblocks/new', ['as' => 'textblocks.store', 'uses' => 'TextblockController@store']);
//    Route::post('/conf/textblocks/edit/{textblockId}', ['as' => 'textblocks.update', 'uses' => 'TextblockController@update']);
//    Route::post('/conf/textblocks/deleteConfirm', ['as' => 'textblocks.deleteConfirm', 'uses' => 'TextblockController@showDeleteConfirm']);
//    Route::post('/conf/textblocks/delete', ['as' => 'textblocks.delete', 'uses' => 'TextblockController@destroy']);
//
//    ## Produkte / Artikel / Dienstleistungen
//    Route::get('/conf/products', ['as' => 'products.list', 'uses' => 'ProductsController@index']);
//    Route::get('/conf/product/{productId}', ['as' => 'products.edit', 'uses' => 'ProductsController@edit']);
//    Route::post('/conf/products/new', ['as' => 'products.store', 'uses' => 'ProductsController@store']);
//    Route::post('/conf/products/edit/{productId}', ['as' => 'products.update', 'uses' => 'ProductsController@update']);
//    Route::post('/conf/products/deleteConfirm', ['as' => 'product.deleteConfirm', 'uses' => 'ProductsController@showDeleteConfirm']);
//    Route::post('/conf/products/delete', ['as' => 'products.delete', 'uses' => 'ProductsController@destroy']);
//
//    # Rechnungen / invoices
//    Route::get('/order_invoice/new/{orderId}', ['as' => 'orderInvoice.create', 'uses' => 'OrderInvoiceController@create']);
//    Route::post('/order_invoice/new', ['as' => 'orderInvoice.store', 'uses' => 'OrderInvoiceController@store']);
//    Route::get('/order_invoice/pdf/{orderInvoiceId}', ['as' => 'orderInvoice.pdf', 'uses' => 'OrderInvoiceController@createPdf']);
//    Route::get('/order_invoice/pdf/print/{orderInvoiceId}', ['as' => 'orderInvoice.pdf.print', 'uses' => 'OrderInvoiceController@createPdfPrint']);
//
//    # Nummernkreise
//    Route::get('/numberranges', ['as' => 'numberRanges.list', 'uses' => 'NumberRangesController@index']);
//    Route::get('/numberrange/{numberRangeId}', ['as' => 'numberRanges.edit', 'uses' => 'NumberRangesController@edit']);
//    Route::post('/numberrange/edit/{numberRangeId}', ['as' => 'numberRanges.update', 'uses' => 'NumberRangesController@update']);
//
//    # Gutschriften
//    Route::get('/creditnotes/edit/{creditNoteId?}', ['as' => 'orderCreditNotes.edit', 'uses' => 'OrderCreditNoteController@edit']);
//
//    # Auftragsdokumente
//    Route::get('/download/{orderDocumentId}', ['as' => 'download.orderDocument', 'uses' => 'OrderDocumentsController@downloadDocument']);
//    Route::post('/orderdocuments/lock', ['as' => 'orderDocument.lock', 'uses' => 'OrderDocumentsController@asyncLock']);
//
//    # Auftragshistorie
//    Route::get('/order/{orderId}/log/new', ['as' => 'orderLog.create', 'uses' => 'OrderLogsController@create']);
//
//    # Auftragsadressen
//    Route::get('/orders/new/addAddress/{orderAddressId}', ['as' => 'customer.addAddress', 'uses' => 'OrderAddressesController@edit']);
//    Route::get('/orders/address/init', ['as' => 'adress.init', 'uses' => 'OrderAddressesController@initAdresses']);
//
//    # Aufragsemails
//    Route::get('/ordermail/new/{orderId}/{appointmentId?}', ['as' => 'orderMail.create', 'uses' => 'OrderMailController@create']);
//    Route::post('/ordermail/send', ['as' => 'orderMail.sendOrderMail', 'uses' => 'OrderMailController@asyncAddOrderMail']);
//
//    # Wiedervorlage
//    Route::get('/followups', ['as' => 'orderFollowUp.list', 'uses' => 'OrderFollowUpController@list']);
//    Route::get('/followups/edit/{orderId?}/{orderFollowUpId?}', ['as' => 'orderFollowUp.edit', 'uses' => 'OrderFollowUpController@edit']);
//    Route::post('/followups/new', ['as' => 'orderFollowUp.store', 'uses' => 'OrderFollowUpController@store']);
//    Route::post('/followups/update', ['as' => 'orderFollowUp.update', 'uses' => 'OrderFollowUpController@update']);
//    Route::get('/followups/delete/{followUpId}', ['as' => 'orderFollowUp.destroy', 'uses' => 'OrderFollowUpController@destroy']);
//    Route::post('/followups/asyncDestroy', ['as' => 'orderFollowUp.asyncDestroy', 'uses' => 'OrderFollowUpController@asyncDestroy']);
//
//
//    ## Controlling
//    Route::get('/controlling', ['as' => 'controlling.list', 'uses' => 'ControllingController@index']);
//    Route::get('/controlling/monthly', ['as' => 'controlling.monthlyList', 'uses' => 'ControllingController@monthlyIndex']);
//    Route::get('/controlling/export', ['as' => 'controlling.export', 'uses' => 'ControllingController@export']);
//    Route::get('/controlling/export/{customerId?}/{monthFrom?}-{yearFrom?}/{monthTo?}-{yearTo?}', ['as' => 'controlling.exportCsv', 'uses' => 'ControllingController@exportCsv']);
//    Route::get('/controlling/exportOrderstate/{orderstateId}/{dateFrom?}/{dateTo?}', ['as' => 'controlling.exportCsvOrderstate', 'uses' => 'ControllingController@exportCsvOrderstate']);
//    Route::get('/controlling/exportOperator/{operatorId}/{dateFrom?}/{dateTo?}', ['as' => 'controlling.exportCsvOperator', 'uses' => 'ControllingController@exportCsvOperator']);
//    Route::get('/controlling/exportCredit/{dateFrom?}/{dateTo?}', ['as' => 'controlling.exportCsvCredit', 'uses' => 'ControllingController@exportCsvCredit']);
//
//    # Kalender
//    # Ajax-Abruf eines Calendar-Summary
//    Route::get('/operator/calendar/requestCalendarSummary', ['as' => 'operator.calendar.requestCalendarSummary', 'uses' => 'OperatorCalendarController@requestCalendarSummary']);
//    # Ajax-Abruf eines Calendar
//    Route::get('/operator/calendar/requestCalendar', ['as' => 'operator.calendar.requestCalendar', 'uses' => 'OperatorCalendarController@requestCalendar']);
//    # Aktualisierung eines Order Appointment Operator (neuer Bearbeiter oder Tag)
//    Route::post('/operator/calendar/updateAppointmentOperator', ['as' => 'operator.calendar.updateAppointmentOperator', 'uses' => 'OperatorCalendarController@updateAppointmentOperator']);
//    # Aktualisierung von Krankheit und Urlaub
//    Route::post('/operator/calendar/updateOperatorCalendar', ['as' => 'operator.calendar.updateOperatorCalendar', 'uses' => 'OperatorCalendarController@updateOperatorCalendar']);
//    # Sammelkalender aller Mitarbeiter
//    Route::get('/operator/calendar/summary', ['as' => 'operator.calendar.summary', 'uses' => 'OperatorCalendarController@summary']);
//    ## LAYER
//    Route::get('/operator/calendar/summarylayer', ['as' => 'operator.calendar.summarylayer', 'uses' => 'OperatorCalendarController@summarylayer']);
//    Route::get('/operator/calendar/{id}', ['as' => 'operator.calendar.list', 'uses' => 'OperatorCalendarController@index']);
});

Route::get('/', ['as' => 'indexOutside', 'uses' => 'GuestController@index']);

# Registrierung neuer Mandant
Route::get('/client/newClient/{token}', ['as' => 'client.showClientAdminCreation', 'uses' => 'ClientController@showClientAdminCreation']);
Route::post('/client/newClient/admin', ['as' => 'client.registerFirstClientAdmin', 'uses' => 'ClientController@registerFirstClientAdmin']);

# User: Passwort zurücksetzen
Route::get('/user/edit/passwordReset/{token}', ['as' => 'user.passwordResetLink', 'uses' => 'UserController@resetPassword']);
Route::post('/user/edit/passwordReset', ['as' => 'user.passwordResetHandle', 'uses' => 'UserController@handlePasswordReset']);

#Route::get('/clearusertokens', 'UserTokenController@clearUserTokenTable');
#Route::get('/upload/cleanUpTmpFiles', ['as' => 'upload.cleanUpTmpFiles', 'uses' => 'UploadController@cleanUpTmpFiles']);


# Login etc.
Auth::routes();

# Registrierungspfad überschreiben, damit keine Registrierung von außen möglich ist
Route::get('/register', 'HomeController@index')->name('register');
