<?php
use App\Http\Controllers\UserController;
?>

<?php $__env->startSection('content'); ?>
    <main class="contentContainer">

        <h1>Auftragstypen</h1>


        <div class="row">
            <div class="col-12 col-md-3 text-md-center">
                <?php if(UserController::checkRight("createOrderTypes", $user)): ?>
                    <a class="button editOrderType"
                       href="#"
                       data-ordertypeid="0">Neuen Auftragstyp anlegen</a>
                <?php endif; ?>
            </div>
        </div>

        <div class="clearfix">&nbsp;</div>

        <div class="row no-gutters" data-itable='1'>
            <div class="col-12">
                <div class="row no-gutters listHeader">
                    <div class="col-5">
                        Auftragstyp
                    </div>
                    <div class="col-5">
                        Startstatus
                    </div>
                    <div class="col-2">
                        Aktionen
                    </div>
                </div>
                <?php if(count($orderTypes) > 0): ?>
                    <?php $__currentLoopData = $orderTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $orderType): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="row no-gutters align-items-center listItem">

                            <div class="col-5 label">
                                <?php echo e($orderType->label); ?>

                            </div>

                            <div class="col-5">
                                <?php echo e($orderType->order_statuses->label); ?>

                            </div>

                            <div class="col-2">
                                <div class="row no-gutters">
                                    <div class="">
                                        <?php if(UserController::checkRight("editOrderTypes", $user)): ?>
                                            <a href="#"
                                               data-ordertypeid="<?php echo e($orderType->id); ?>"
                                               class="editOrderType"
                                               title="Bearbeiten">
                                                <i class="fal fa-pencil-alt"></i>
                                            </a>
                                        <?php endif; ?>
                                    </div>

                                    <div class="">
                                        <?php if(UserController::checkRight("deleteOrderTypes", $user)): ?>
                                            <a href="#"
                                               data-ordertypeid="<?php echo e($orderType->id); ?>"
                                               class="deleteOrderType"
                                               title="Löschen">
                                                <i class="fal fa-trash-alt"></i>
                                            </a>
                                        <?php endif; ?>
                                    </div>

                                </div>
                            </div>

                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                    <div id="noListEntries" class="row">
                        <div class="col-12 text-center">
                            Keine Auftragstypen hinterlegt.
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </main>

    <?php echo $__env->make('layouts.overlay', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


    <script>

        jQuery(function () {
            // Auftragstyp anlegen/bearbeiten: Overlay öffnen
            jQuery(".editOrderType").click(function () {
                showLoadingSpinner();

                // Ajax-Parameter festlegen
                var url = '/conf/ordertype';
                var data = {};
                data["orderTypeId"] = jQuery(this).data("ordertypeid");

                // Handling für erfolgreichen Request
                successFunction = function (response) {
                    if (response.response == "success") {
                        jQuery("#loadingSpinner").hide();
                        jQuery("#editorContent").html(response.editorHTML);
                        jQuery("#listEditor").addClass("windowNarrow");
                        jQuery("#listEditor").fadeIn();
                    }
                    else {
                        errorFunction(response);
                    }
                };

                // Handling für fehlerhaften Request
                errorFunction = function (response) {
                    showModalBox("Es ist ein Fehler aufgetreten.", response.message);
                    hideLoadingSpinner();
                };

                // Ajax aufrufen
                fireAjax(url, data, successFunction, errorFunction);
            });


            // Auftragstyp löschen: Overlay öffnen
            jQuery(".deleteOrderType").click(function () {
                showLoadingSpinner();

                // Ajax-Parameter festlegen
                var url = '/conf/ordertypes/deleteConfirm';
                var data = {};
                data["orderTypeId"] = jQuery(this).data("ordertypeid");

                // Handling für erfolgreichen Request
                successFunction = function (response) {
                    if (response.response == "success") {
                        jQuery("#loadingSpinner").hide();
                        jQuery("#editorContent").html(response.editorHTML);
                        jQuery("#listEditor").addClass("windowModal");
                        jQuery("#listEditor").fadeIn();
                    }
                    else {
                        errorFunction(response);
                    }
                };

                // Handling für fehlerhaften Request
                errorFunction = function (response) {
                    showModalBox("Es ist ein Fehler aufgetreten.", response.message);
                    hideLoadingSpinner();
                };

                // Ajax aufrufen
                fireAjax(url, data, successFunction, errorFunction);

            });

        });
    </script>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\Projekte\KTK\ktkmouldtec\resources\views/order_conf/order_types/list.blade.php ENDPATH**/ ?>