<?php
use App\Http\Controllers\UserController;
?>

<?php $__env->startSection('content'); ?>
    <main class="contentContainer">

        <h1>Projekttypen</h1>


        <div class="row">
            <div class="col-12 col-md-3 text-md-center">
                <?php if(UserController::checkRight("createProjectTypes", $user)): ?>
                    <a class="button editProjectType"
                       href="#"
                       data-projecttypeid="0">Neuen Projekttyp anlegen</a>
                <?php endif; ?>
            </div>
        </div>

        <div class="clearfix">&nbsp;</div>

        <div class="row no-gutters" data-itable='1'>
            <div class="col-12">
                <div class="row no-gutters listHeader">
                    <div class="col-5">
                        Auftragstyp
                    </div>
                    <div class="col-5">
                        Hinterlegte Dokumente
                    </div>
                    <div class="col-2">
                        Aktionen
                    </div>
                </div>
                <?php if(count($projectTypes) > 0): ?>
                    <?php $__currentLoopData = $projectTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $projectType): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="row no-gutters align-items-center listItem">

                            <div class="col-5 label">
                                <?php echo e($projectType->title); ?>

                            </div>

                            <div class="col-5">





                            </div>

                            <div class="col-2">
                                <div class="row no-gutters">
                                    <div class="">
                                        <?php if(UserController::checkRight("editProjectTypes", $user)): ?>
                                            <a href="<?php echo e(route('projectTypes.editPage', [$projectType->id])); ?>"
                                               data-projecttypeid="<?php echo e($projectType->id); ?>"
                                               class="editProjectType"
                                               title="Bearbeiten">
                                                <i class="fal fa-pencil-alt"></i>
                                            </a>
                                        <?php endif; ?>
                                    </div>

                                    <div class="">
                                        <?php if(UserController::checkRight("deleteProjectTypes", $user)): ?>
                                            <a href="#"
                                               data-projecttypeid="<?php echo e($projectType->id); ?>"
                                               class="deleteProjectType"
                                               title="Löschen">
                                                <i class="fal fa-trash-alt"></i>
                                            </a>
                                        <?php endif; ?>
                                    </div>

                                </div>
                            </div>

                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                    <div id="noListEntries" class="row">
                        <div class="col-12 text-center">
                            Keine Projekttypen hinterlegt.
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </main>

    <?php echo $__env->make('layouts.overlay', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


    <script>

        jQuery(function () {
            // Auftragstyp anlegen/bearbeiten: Overlay öffnen
            jQuery(".editProjectType").click(function () {
                showLoadingSpinner();

                if (jQuery(this).data("projecttypeid") != "0") return;

                // Ajax-Parameter festlegen
                var url = '/conf/projecttype';
                var data = {};
                data["projectTypeId"] = jQuery(this).data("projecttypeid");

                // Handling für erfolgreichen Request
                successFunction = function (response) {
                    if (response.response == "success") {
                        jQuery("#loadingSpinner").hide();
                        jQuery("#editorContent").html(response.editorHTML);
                        jQuery("#listEditor").addClass("windowNarrow");
                        jQuery("#listEditor").fadeIn();
                    }
                    else {
                        errorFunction(response);
                    }
                };

                // Handling für fehlerhaften Request
                errorFunction = function (response) {
                    showModalBox("Es ist ein Fehler aufgetreten.", response.message);
                    hideLoadingSpinner();
                };

                // Ajax aufrufen
                fireAjax(url, data, successFunction, errorFunction);

            });


            // Auftragstyp löschen: Overlay öffnen
            jQuery(".deleteProjectType").click(function () {
                showLoadingSpinner();

                // Ajax-Parameter festlegen
                var url = '/conf/projecttypes/deleteConfirm';
                var data = {};
                data["projectTypeId"] = jQuery(this).data("projecttypeid");

                // Handling für erfolgreichen Request
                successFunction = function (response) {
                    if (response.response == "success") {
                        jQuery("#loadingSpinner").hide();
                        jQuery("#editorContent").html(response.editorHTML);
                        jQuery("#listEditor").addClass("windowModal");
                        jQuery("#listEditor").fadeIn();
                    }
                    else {
                        errorFunction(response);
                    }
                };

                // Handling für fehlerhaften Request
                errorFunction = function (response) {
                    showModalBox("Es ist ein Fehler aufgetreten.", response.message);
                    hideLoadingSpinner();
                };

                // Ajax aufrufen
                fireAjax(url, data, successFunction, errorFunction);

            });

        });
    </script>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\Projekte\KTK\ktkmouldtec\resources\views/project_conf/project_types/list.blade.php ENDPATH**/ ?>