<?php

use App\Http\Controllers\UserController;

if ($proceduralInstruction->id == NULL) $mode = "create";
else $mode = "edit";

?>

<header>Verfahrensanweisungen <?php if($mode=="create"): ?> anlegen <?php elseif($mode=="edit"): ?> bearbeiten <?php endif; ?></header>


<div class="container">
    <?php if($mode=="create"): ?>
        <?php echo BootForm::open(["id" => "editProceduralInstruction",
                             "route" => "proceduralinstructions.store",
                             "method" => "POST",
                             "enctype" => "multipart/form-data"]);; ?>

    <?php elseif($mode=="edit"): ?>
        <?php echo BootForm::open(["id" => "editProceduralInstruction",
                             "route" => array("proceduralinstructions.update", $proceduralInstruction->id),
                             "method" => "POST",
                             "enctype" => "multipart/form-data"]);; ?>

    <?php endif; ?>


    <div class="form-group row">
        <label for="label" class="col-12 col-lg-4 col-form-label">Bezeichnung</label>
        <div class="col-12 col-lg-8">
            <input type="text" class="form-control" id="title" name="title"
                   value="<?php echo e($proceduralInstruction->title); ?>">
        </div>
    </div>

</div>

<footer>
    <div class="form-group row align-items-center">
        <div class="col-6 text-left">
            <button type="button" id="closeListEditorButton" class="btn btn-secondary">
                Abbrechen
            </button>
        </div>

        <div class="col-6 text-right">
            <button type="submit" form="editProceduralInstruction" class="btn btn-primary">
                Speichern
            </button>
        </div>
    </div>
</footer>

<?php echo BootForm::close(); ?>




<?php if(isset($validator)): ?>
    <script type="text/javascript" src="<?php echo e(asset('vendor/jsvalidation/js/jsvalidation.js')); ?>"></script>
    <?php if(is_array($validator)): ?>
        <?php $__currentLoopData = $validator; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vali): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php echo $vali; ?>

        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php else: ?>
        <?php echo $validator; ?>

    <?php endif; ?>
<?php endif; ?>
<?php /**PATH E:\Projekte\KTK\ktkmouldtec\resources\views/procedural_instruction/edit.blade.php ENDPATH**/ ?>