<?php
$rechnungsDatum = (new Carbon\Carbon())->toDateString();
?>
<header>Rechnung erstellen</header>

<form id="addOrderInvoice" name="addOrderInvoice" action="javascript:void(0);">

    <div class="container">
        <div class="form-group row">
            <h3 class="col-12 col-lg-4">
                <label for="project_name">Projektbezeichnung</label>
            </h3>
            <div class="col-12 col-lg-8">
                <input type="text" name="project_name" class="form-control">
            </div>
        </div>

        <div class="row mt-1">
            <div class="col-12">
                <h3>Datum</h3>
            </div>
        </div>
        <div class="form-group row">
            <label for="date_of_issue" class="col-12 col-lg-3 col-form-label">Datum der Ausstellung</label>
            <div class="col-12 col-lg-3">
                <input type="date" value="<?php echo e($rechnungsDatum); ?>" name="date_of_issue" class="form-control"
                       max="9999-12-31"></div>
            <label for="service_provision_date" class="col-12 col-lg-3 col-form-label">Datum der
                Leistungserbringung</label>
            <div class="col-12 col-lg-3">
                <input type="date" value="<?php echo e($rechnungsDatum); ?>" name="service_provision_date" class="form-control"
                       max="9999-12-31">
            </div>
        </div>

        <div class="row mt-1">
            <div class="col-12">
                <h4>Artikel</h4>
            </div>
        </div>

        <div class="inlineList productChooseList fancyscrollbar">
            <div class="row listControls">
                <div class="col-6">
                    <div class="searchCustomer">
                        <input type="text" class="slide-input search small" id="searchFor"
                               autocomplete="off"
                               data-shownosearchresults="noProducts">
                    </div>
                </div>
            </div>
            <div class="row innerListHeader">
                <div class="col-1">

                </div>
                <div class="col-3">
                    Artikelnummer
                </div>
                <div class="col-6">
                    Name
                </div>
                <div class="col-2">
                    Preis (EUR)
                </div>
            </div>
            <div>
                <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                    $price = $product->getPriceByPricegroup($order->customer->pricegroup);
                    ?>
                    <div class="row searchItem listItem"
                         data-invoice-position="1"
                         data-product-id="<?php echo e($product->id); ?>"
                         data-price="<?php echo e($price); ?>"
                         data-product-name="<?php echo e($product->name); ?>"
                         data-product-number="<?php echo e($product->product_number); ?>"
                         data-search-for="<?php echo e($product->product_number); ?> <?php echo e($product->name); ?>">
                        <div class="col-1">
                            <label for="plusButton" data-action="addProduct" data-product-id="<?php echo e($product->id); ?>">
                                <i class="fas fa-plus-circle"></i></label>
                        </div>
                        <div class="col-3">
                            <?php echo e($product->product_number); ?>

                        </div>
                        <div class="col-6">
                            <?php echo e($product->name); ?>

                        </div>
                        <div class="col-2">
                            <?php echo e($price); ?>

                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <div data-nosearchresults="noProducts">Für diese Sucheingabe gibt es leider keine Ergebnisse.</div>
            </div>

        </div>

        <div class="row mt-3">
            <div class="col-12">
                <h4>Positionen</h4>
            </div>
        </div>

        <div class="row no-gutters listHeader">
            <div class="col-1">
            </div>
            <div class="col-2">
                Artikelnummer
            </div>
            <div class="col-5">
                Name
            </div>
            <div class="col-2">
                Preis
            </div>
            <div class="col-2">
                Stück
            </div>
        </div>
        <div id="positionsContainer">
            <div class="row noListEntries">
                <div class="col-12 text-center">
                    Noch keine Rechnungspositionen hinzugefügt.
                </div>
            </div>
        </div>

        <input type="hidden" name="orderID" id="orderID" value="<?php echo e($order->id); ?>">

        <div class="alert alert-danger mt-5">
            <div class="alertIcon">
                <i class="far fa-exclamation-circle"></i>
            </div>
            <div>
                Beim Erzeugen einer Rechnung wird die Auftrags-Detailseite neu geladen. Stellen Sie sicher, dass alle
                anderen Arbeiten abgeschlossen sind und der Auftrag vollständig gespeichert wurde. Ungespeicherte
                Änderungen gehen ansonsten verloren.
            </div>
        </div>

    </div>
</form>

<footer>
    <div class="form-group row align-items-center">
        <div class="col-6 text-left">
            <button type="button" id="closeListEditorButton" class="btn btn-secondary">
                Abbrechen
            </button>
        </div>

        <div class="col-6 text-right">
            <button type="submit" form="addOrderInvoice" class="btn btn-primary">
                Erzeugen
            </button>
        </div>
    </div>
</footer>

<script>
    // Produkt zu Positionsliste hinzufügen
    jQuery(document).on("click", "[data-action=addProduct]", function () {

        // Daten des Artikels auslesen
        let productId = jQuery(this).data("product-id");
        let productData = jQuery("div.listItem[data-product-id=" + productId + "]");

        // Position bauen und hinzufügen
        let newPosition = '<div class="row no-gutters listItem" data-invoice-position="1" data-product-id="' + productId + '">\n' +
            '                        <div class="col-1">\n' +
            '                            <label for="minusButton" data-action="removeProduct" data-product-id="' + productId + '">\n' +
            '                                <i class="fas fa-minus-circle"></i></label>\n' +
            '                        </div>\n' +
            '                        <div class="col-2">\n' +
            '                            ' + productData.data("product-number") +
            '                        </div>\n' +
            '                        <div class="col-5">\n' +
            '                            ' + productData.data("product-name") +
            '                        </div>\n' +
            '                        <div class="col-2 pr-1">\n' +
            '                            <input type="text" value="' + productData.data("price") + '" name="price" class="form-control" placeholder="0.00"/>\n' +
            '                        </div>\n' +
            '                        <div class="col-2">\n' +
            '                            <input type="text" value="0" name="quantity" class="form-control" placeholder="0.00"/>\n' +
            '                        </div>\n' +
            '                    </div>';

        jQuery("div#positionsContainer .noListEntries").fadeOut();
        jQuery("div#positionsContainer").append(newPosition);

        // Artikel ausblenden
        productData.fadeOut();
    });


    // Produkt aus Positionsliste entfernen
    jQuery(document).on("click", "[data-action=removeProduct]", function () {

        // Position entfernen
        let productId = jQuery(this).data("product-id");
        jQuery("div#positionsContainer div.listItem[data-product-id=" + productId + "]").remove();

        // ggf. "Keine Positionen hinterlegt" wieder einblenden
        if (jQuery("div#positionsContainer div.listItem").length <= 0)
            jQuery("div#positionsContainer .noListEntries").fadeIn();

        // Artikel eiblenden
        jQuery("div.listItem[data-product-id=" + productId + "]").fadeIn();
    });


    jQuery(document).ready(function () {
        jQuery("button[type=submit][form=addOrderInvoice]").click(function () {

            // Eingabe validieren
            if (!jQuery("form#addOrderInvoice").valid()) {
                showModalBox("Validierungsfehler", "Bitte Eingaben überprüfen.")
                return;
            }

            let order = {};
            order["id"] = jQuery("form[name=addOrderInvoice] input[name=orderID]").val();
            order["date_of_issue"] = jQuery("form[name=addOrderInvoice] input[name=date_of_issue]").val();
            order["project_name"] = jQuery("form[name=addOrderInvoice] input[name=project_name]").val();
            order["service_provision_date"] = jQuery("form[name=addOrderInvoice] input[name=service_provision_date]").val();
            let products = [];

            jQuery("[data-invoice-position=1]").each(function (index) {
                let productId = jQuery(this).data("product-id");
                let price = jQuery(this).find("input[name=price]").val();
                let quantity = jQuery(this).find("input[name=quantity]").val();

                if (quantity > 0) {
                    products.push([{"productId": productId, "price": price, "quantity": quantity}]);
                }
            });
            order["products"] = products;

            if (products.length == 0) {
                showModalBox("Anlage nicht möglich.", "Zur Rechnungsanlage muss mindestens ein Artikel mit Stückzahl > 0 angelegt werden");
                return;
            }

            // Positionen zum Server senden, so dass die Rechnung generiert werden kann
            showOverlayLoadingSpinner();

            // AJAX-Request zum Versenden der E-Mail starten
            // Ajax-Parameter festlegen
            var url = '/order_invoice/new';

            // Handling für erfolgreichen Request
            successFunction = function (response) {
                if (response.response == "success") {
                    var rand = Math.floor(Math.random() * 100000)
                    // Erfolgreiche Anlage - Seite neu laden
                    let url = "/order/" + order["id"] + "?crn=" + rand + "#order_invoices";
                    window.location.href = url;
                }
                else {
                    errorFunction(response);
                }
            };

            // Handling für fehlerhaften Request
            errorFunction = function (response) {
                showModalBox("Es ist ein Fehler aufgetreten.", response.message);
                hideOverlayLoadingSpinner();
            };
            // Ajax aufrufen
            fireAjax(url, order, successFunction, errorFunction);
        });
    });
</script>


<?php if(isset($validator)): ?>
    <script type="text/javascript" src="<?php echo e(asset('vendor/jsvalidation/js/jsvalidation.js')); ?>"></script>
    <?php if(is_array($validator)): ?>
        <?php $__currentLoopData = $validator; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vali): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php echo $vali; ?>

        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php else: ?>
        <?php echo $validator; ?>

    <?php endif; ?>
<?php endif; ?>
