<?php
use App\User;
use Illuminate\Support\Facades\Storage;
use App\Http\Controllers\UserController;
?>

<?php $__env->startSection('content'); ?>
    <main class="contentContainer">

        <h1>Profil & Einstellungen</h1>

        <div class="row profileSettingsContainer">

            <?php echo $__env->make('user.navEdit', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
            <section class="col-md-8">

                <div class="row">
                    <div class="col-md-12">
                        <h1>Neuen Benutzer erstellen</h1>
                    </div>
                </div>

            <?php echo BootForm::open(["id" => "registerNewUser",
                                "route" => "clientAdmin.newUserRegister",
                                "method" => "POST",
                                "enctype" => "multipart/form-data",
                                "aria-label" => "Register"]);; ?>




                <div class="form-group row">
                    <label for="name" class="col-md-4 col-form-label">Name</label>
                    <div class="col-md-8">
                        <input type="text" class="form-control" id="name" name="name" value="<?php echo e($operator->name); ?>">
                    </div>
                </div>

                <div class="form-group row">
                    <label for="firstname" class="col-md-4 col-form-label">Vorname</label>
                    <div class="col-md-8">
                        <input type="text" class="form-control" id="firstname" name="firstname"
                               value="<?php echo e($operator->firstname); ?>">
                    </div>
                </div>

                <div class="form-group row">
                    <label for="email" class="col-md-4 col-form-label">E-Mail-Adresse</label>
                    <div class="col-md-8">
                        <input type="email" class="form-control" id="email" name="email" value="<?php echo e($operator->email); ?>">
                    </div>
                </div>

                <div class="form-group row">
                    <label for="email" class="col-md-4 col-form-label">E-Mail-Adresse bestätigen</label>
                    <div class="col-md-8">
                        <input type="email" class="form-control" id="email-confirm" name="email_confirmation" value="<?php echo e($operator->email); ?>">
                    </div>
                </div>

                <input type="hidden" name="operator_id" value="<?php echo e($operator->id); ?>">

                <div class="form-group row mb-0">
                    <div class="col-md-8 offset-md-4 text-md-right">
                        <button type="submit" class="btn btn-primary btn-big">
                            Registrieren
                        </button>
                    </div>
                </div>

                <?php echo BootForm::close();; ?>

            </section>
        </div>
    </main>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>