<?php
use App\Http\Controllers\UserController;
?>

<?php $__env->startSection('content'); ?>
    <main class="contentContainer">

        <h1>Nummernkreise</h1>

        <div class="clearfix">&nbsp;</div>

        <div class="row no-gutters" data-itable='1'>
            <div class="col-12">
                <div class="row no-gutters listHeader">
                    <div class="col-6">
                        Nummernkreis
                    </div>
                    <div class="col-5">
                        Aktueller Stand
                    </div>
                </div>
                <?php if(count($numberRanges) > 0): ?>
                    <?php $__currentLoopData = $numberRanges; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $numberRange): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                        <div class="row no-gutters align-items-center listItem">

                            <div class="col-6 label">
                                <a data-numberrangeid="<?php echo e($numberRange->id); ?>"
                                   class="editNumberRange cursorPointer"
                                   title="Bearbeiten"><?php echo e($numberRange->key_label); ?></a>
                            </div>

                            <div class="col-5">
                                <?php echo e($numberRange->current_number); ?>

                            </div>

                            <div class="col-1">
                                <div class="row no-gutters">
                                    <div class="">
                                        <?php if(UserController::checkRight("editNumberRanges", $user)): ?>
                                            <a href="#"
                                               data-numberrangeid="<?php echo e($numberRange->id); ?>"
                                               class="editNumberRange"
                                               title="Bearbeiten">
                                                <i class="fal fa-pencil-alt"></i>
                                            </a>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>

                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                    <div id="noListEntries" class="row">
                        <div class="col-12 text-center">
                            Keine Nummernkreise hinterlegt.
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </main>

    <?php echo $__env->make('layouts.overlay', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

    <script>
        // Nummernkreis bearbeiten
        jQuery(".editNumberRange").click(function () {
            showLoadingSpinner();

            let url = "/numberrange";
            let numberrange_id = jQuery(this).data("numberrangeid");

            $.get(url + '/' + numberrange_id, function (data) {

                if (data.response == "success") {
                    jQuery("#loadingSpinner").hide();
                    jQuery("#editorContent").html(data.editorHTML);
                    jQuery("#listEditor").addClass("windowNarrow");
                    jQuery("#listEditor").fadeIn();
                }
                else {
                    error = true;
                    showModalBox("Es ist ein Fehler aufgetreten.", data.message);
                    hideLoadingSpinner();
                }
            });
        });


    </script>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>