<?php

use App\Http\Controllers\UserController;

if ($variable->id == NULL) $mode = "create";
else $mode = "edit";

?>

<header>Variable <?php if($mode=="create"): ?> anlegen <?php elseif($mode=="edit"): ?> bearbeiten <?php endif; ?></header>


<div class="container">
    <?php if($mode=="create"): ?>
        <?php echo BootForm::open(["id" => "editVariable",
                             "route" => "variables.store",
                             "method" => "POST",
                             "enctype" => "multipart/form-data"]);; ?>

    <?php elseif($mode=="edit"): ?>
        <?php echo BootForm::open(["id" => "editVariable",
                             "route" => array("articleVariables.update", $variable->id),
                             "method" => "POST",
                             "enctype" => "multipart/form-data"]);; ?>

    <?php endif; ?>

    <input type="hidden" name="ref_type" value="<?php echo e($variable->ref_type); ?>">
    <input type="hidden" name="variableId" value="<?php echo e($variable->id); ?>">
    <div class="form-group row">
        <label for="label" class="col-12 col-lg-4 col-form-label">Bezeichnung</label>
        <div class="col-12 col-lg-8 mb-2">
            <input type="text" class="form-control" id="title" name="title"
                   value="<?php echo e($variable->title); ?>">
        </div>
        <label for="label" class="col-12 col-lg-4 col-form-label">Bez. in Dokument</label>
        <div class="col-12 col-lg-8 mb-2">
            <input type="text" class="form-control" id="variable_title" name="variable_title"
                   value="<?php echo e($variable->variable_title); ?>">
        </div>
        <label for="label" class="col-12 col-lg-4 col-form-label">Variablentyp</label>
        <div class="col-12 col-lg-8 mb-2">
            <select class="form-control" id="variable_type" name="variable_type"
                   value="<?php echo e($variable->variable_type); ?>">
                <option value="value">Wert / Text</option>
                <option value="image">Bild</option>
            </select>
        </div>
    </div>

</div>

<footer>
    <div class="form-group row align-items-center">
        <div class="col-6 text-left">
            <button type="button" id="closeListEditorButton" class="btn btn-secondary">
                Abbrechen
            </button>
        </div>

        <div class="col-6 text-right">
            <button type="submit" form="editVariable" class="btn btn-primary">
                Speichern
            </button>
        </div>
    </div>
</footer>


<?php echo BootForm::close(); ?>




<?php if(isset($validator)): ?>
    <script type="text/javascript" src="<?php echo e(asset('vendor/jsvalidation/js/jsvalidation.js')); ?>"></script>
    <?php if(is_array($validator)): ?>
        <?php $__currentLoopData = $validator; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vali): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php echo $vali; ?>

        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php else: ?>
        <?php echo $validator; ?>

    <?php endif; ?>
<?php endif; ?>
<script>
    jQuery(document).ready(function(){
        jQuery('#title').keyup(function(){
            jQuery('#variable_title').val(jQuery('#title').val().toLowerCase().split(' ').join('_'));
        });
    });
</script><?php /**PATH E:\Projekte\KTK\ktkmouldtec\resources\views/variables/articleVariables/edit.blade.php ENDPATH**/ ?>