<?php
use App\Http\Controllers\UserController;
use App\Textblock;
?>

<?php $__env->startSection('content'); ?>
    <main class="contentContainer">

        <h1>Artikel / Dienstleistungen</h1>

        <div class="row">
            <div class="col-md-12">
                <div class="row">
                    <div class="col-12 col-md-3 text-md-center">
                        <?php if(UserController::checkRight("createProducts", $user)): ?>
                            <a class="button editProduct"
                               href="#"
                               data-productid="0">Neuen Artikel anlegen</a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>

        <div class="clearfix">&nbsp;</div>

        <div class="row no-gutters" data-itable='1'>
            <div class="col-12">
                <div class="row no-gutters listHeader">
                    <div class="col-2">
                        Art-Nr.
                    </div>
                    <div class="col-4">
                        Bezeichnung
                    </div>
                    <div class="col-1 text-right">
                        Preis 1
                    </div>
                    <div class="col-1 text-right">
                        Preis 2
                    </div>
                    <div class="col-1 text-right">
                        Preis 3
                    </div>
                    <div class="col-1 text-right">
                        Preis 4
                    </div>
                </div>
                <?php if(count($products) > 0): ?>
                    <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                        <div class="row no-gutters align-items-center listItem">

                            <div class="col-2 label">
                                <a data-productid="<?php echo e($product->id); ?>"
                                   class="editProduct cursorPointer"
                                   title="Bearbeiten"><?php echo e($product->product_number); ?></a>
                            </div>

                            <div class="col-4" style="word-break: break-word; padding-right: 10px;">
                                <?php echo e($product->name); ?>

                            </div>

                            <div class="col-1 text-right">
                                <?php echo e($product->price_1); ?>

                            </div>
                            <div class="col-1 text-right">
                                <?php echo e($product->price_2); ?>

                            </div>
                            <div class="col-1 text-right">
                                <?php echo e($product->price_3); ?>

                            </div>
                            <div class="col-1 text-right">
                                <?php echo e($product->price_4); ?>

                            </div>

                            <div class="col-1">
                            </div>

                            <div class="col-1">
                                <div class="row no-gutters">
                                    <div class="">
                                        <?php if(UserController::checkRight("editProducts", $user)): ?>
                                            <a href="#"
                                               data-productid="<?php echo e($product->id); ?>"
                                               class="editProduct"
                                               title="Bearbeiten">
                                                <i class="fal fa-pencil-alt"></i>
                                            </a>
                                        <?php endif; ?>
                                    </div>

                                    <div class="">
                                        <?php if(UserController::checkRight("deleteProducts", $user)): ?>
                                            <a href="#"
                                               data-productid="<?php echo e($product->id); ?>"
                                               class="deleteProduct"
                                               title="Löschen">
                                                <i class="fal fa-trash-alt"></i>
                                            </a>
                                        <?php endif; ?>
                                    </div>

                                </div>
                            </div>

                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                    <div id="noListEntries" class="row">
                        <div class="col-12 text-center">
                            Keine Produkte hinterlegt.
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </main>

    <?php echo $__env->make('layouts.overlay', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

    <script>
        // Neuen Textbaustein anlegen / Bestehenden bearbeiten
        jQuery(".editProduct").click(function () {
            showLoadingSpinner();

            let url = "/conf/product";
            let product_id = jQuery(this).data("productid");

            $.get(url + '/' + product_id, function (data) {

                if (data.response == "success") {
                    jQuery("#loadingSpinner").hide();
                    jQuery("#editorContent").html(data.editorHTML);
                    jQuery("#listEditor").addClass("windowNarrow");
                    jQuery("#listEditor").fadeIn();
                }
                else {
                    error = true;
                    showModalBox("Es ist ein Fehler aufgetreten.");
                }
            });
        });

        // Textbaustein löschen: Overlay öffnen
        jQuery(".deleteProduct").click(function () {
            showLoadingSpinner();

            // Ajax-Parameter festlegen
            var url = '/conf/products/deleteConfirm';
            var data = {};
            data["productId"] = jQuery(this).data("productid");

            // Handling für erfolgreichen Request
            successFunction = function (response) {
                if (response.response == "success") {
                    jQuery("#loadingSpinner").hide();
                    jQuery("#editorContent").html(response.editorHTML);
                    jQuery("#listEditor").addClass("windowModal");
                    jQuery("#listEditor").fadeIn();
                }
                else {
                    errorFunction();
                }
            };

            // Handling für fehlerhaften Request
            errorFunction = function (jqXHR, textStatus, errorThrown) {
                //console.log(JSON.stringify(jqXHR));
                //console.log("AJAX error: " + textStatus + ' : ' + errorThrown);

                jQuery("#loadingSpinner").hide();
                showModalBox("Es ist ein Fehler aufgetreten.");
                jQuery("#listEditor").removeClass();
                jQuery("#listOverlay").hide();
            };

            // Ajax aufrufen
            fireAjax(url, data, successFunction, errorFunction);

        });
    </script>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>