<?php
use App\User;
use App\Http\Controllers\UserController;
?>

<?php $__env->startSection('content'); ?>
    <main class="contentContainer">

        <h1>Profil & Einstellungen</h1>

        <div class="row profileSettingsContainer">

            <?php echo $__env->make('user.navEdit', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

            <section class="col-9 userData">

                <div class="row">
                    <div class="col-12">
                        <h1>Userliste</h1>
                        <div class="row">
                            <div class="col-12">
                                <div class="row no-gutters ">
                                    <div class="col-3 text-center">
                                        <?php if(UserController::checkRight("createUser", $user)): ?>
                                            <a class="button" href="<?php echo e(route('clientAdmin.newUser')); ?>">Neuen Benutzer
                                                anlegen</a>
                                        <?php endif; ?>
                                    </div>

                                    <div class="col-12 col-md-3 offset-md-6 text-right">
                                        <input type="text"
                                               class="slide-input search"
                                               id="searchFor"
                                               autocomplete="off"
                                               data-shownosearchresults="noUsers"
                                        >
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">&nbsp;</div>

                        <div class="row userList" data-itable='1'>
                            <div class="col-12">
                                <div class="row no-gutters userListHeader listHeader">
                                    <div class="col-10" style="padding-left:30px;">
                                        Name
                                    </div>
                                    <div class="col-2">
                                        Aktionen
                                    </div>
                                </div>
                                <?php $__currentLoopData = $userList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $userItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="row no-gutters align-items-center listItem searchItem"
                                         data-search-for="<?php echo e($userItem->name); ?> <?php echo e($userItem->firstname); ?>">

                                        <div class="col-10">
                                            <div class="row">
                                                <div class="col-2 itablehidemobile">
                                                    <div class="img"
                                                         style="background-image: url('<?php echo e($userItem->getImage()); ?>');"></div>
                                                </div>
                                                <div class="col-10 mb-auto mt-auto">
                                                    <div class="row">
                                                        <div class="col-12 label">
                                                            <a class="editUser cursorPointer"
                                                               data-userid="<?php echo e($userItem->id); ?>"
                                                               title="Bearbeiten">
                                                                <?php echo e($userItem->name); ?> <?php echo e($userItem->firstname); ?>

                                                            </a>
                                                        </div>
                                                    </div>
                                                    <div class="row">
                                                        <div class="col-12">
                                                            <?php echo e($userItem->email); ?>

                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-2">
                                            <div class="row no-gutters">

                                                <div class="">
                                                    <?php if(UserController::checkRight("editProfiles", $user)): ?>
                                                        <a href="#"
                                                           data-userid="<?php echo e($userItem->id); ?>"
                                                           class="editUser"
                                                           title="Bearbeiten">
                                                            <i class="fal fa-pencil-alt"></i>
                                                        </a>
                                                    <?php endif; ?>

                                                </div>


                                                <div class="">
                                                    <?php if(UserController::checkRight("editUserRights", $user) &&
                                                        $userItem->id != $user->id): ?>
                                                        <a href="#"
                                                           id="<?php echo e($userItem->id); ?>"
                                                           class="editUserRights"
                                                           title="Benutzerrechte verwalten">
                                                            <i class="fal fa-key"></i>
                                                        </a>
                                                    <?php endif; ?>
                                                </div>

                                                <div class="moreDots" id="<?php echo e($userItem->id); ?>">
                                                    <a href="#" id="<?php echo e($userItem->id); ?>"
                                                       class="moreUserActions"
                                                       title="Mehr...">
                                                        <i class="fas fa-ellipsis-v"></i>
                                                    </a>
                                                    <div class="moreMenu" id="<?php echo e($userItem->id); ?>">
                                                        <span class="more">Weitere Aktionen:</span>
                                                        <?php if(UserController::checkRight("resetPassword", $user)): ?>
                                                            <a href="<?php echo e(route('clientAdmin.resetUserPassword', ["userID" => $userItem->id])); ?>">Passwort
                                                                zurücksetzen</a>
                                                        <?php endif; ?>

                                                        <?php if(UserController::checkRight("deleteUser", $user) &&
                                                           $userItem->id != $user->id): ?>
                                                            <a href="#" id="<?php echo e($userItem->id); ?>" class="deleteUser">
                                                                User löschen
                                                            </a>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <div data-nosearchresults="noUsers" class="row">
                                    <div class="col-12 text-center">
                                        Zu dieser Eingabe gibt es leider keine Ergebnisse. Bitte versuche es erneut.
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </section>

        </div>

    </main>

    <?php echo $__env->make('layouts.overlay', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

    <script>

        jQuery(function () {
            // User bearbeiten: Events abfangen
            jQuery(".editUser").click(function () {
                showLoadingSpinner();

                // Ajax-Parameter festlegen
                var url = '/clientadmin/userEdit';
                var data = {};
                data["userID"] = jQuery(this).data("userid");

                // Handling für erfolgreichen Request
                successFunction = function (response) {
                    if (response.response == "success") {
                        jQuery("#loadingSpinner").hide();
                        jQuery("#editorContent").html(response.editorHTML);
                        jQuery("#listEditor").addClass("windowNarrow");
                        jQuery("#listEditor").fadeIn();
                    }
                    else {
                        errorFunction(response);
                    }
                };

                // Handling für fehlerhaften Request
                errorFunction = function (response) {
                    showModalBox("Es ist ein Fehler aufgetreten.", response.message);
                    hideLoadingSpinner();
                };

                // Ajax aufrufen
                fireAjax(url, data, successFunction, errorFunction);
            });

            // User-Berechtigungen bearbeiten: Overlay öffnen
            jQuery(".editUserRights").click(function () {
                showLoadingSpinner();

                // Ajax-Parameter festlegen
                var url = '/clientadmin/userRightsEdit';
                var data = {};
                data["userID"] = this.id;

                // Handling für erfolgreichen Request
                successFunction = function (response) {
                    if (response.response == "success") {
                        jQuery("#loadingSpinner").hide();
                        jQuery("#editorContent").html(response.editorHTML);
                        jQuery("#listEditor").addClass("windowWide");
                        jQuery("#listEditor").fadeIn();
                    }
                    else {
                        errorFunction(response);
                    }
                };

                // Handling für fehlerhaften Request
                errorFunction = function (response) {
                    showModalBox("Es ist ein Fehler aufgetreten.", response.message);
                    hideLoadingSpinner();
                };

                // Ajax aufrufen
                fireAjax(url, data, successFunction, errorFunction);

            });


            // User löschen: Overlay öffnen
            jQuery(".deleteUser").click(function () {
                showLoadingSpinner();

                // Ajax-Parameter festlegen
                var url = '/clientadmin/userDelete';
                var data = {};
                data["userID"] = this.id;

                // Handling für erfolgreichen Request
                successFunction = function (response) {
                    if (response.response == "success") {
                        jQuery("#loadingSpinner").hide();
                        jQuery("#editorContent").html(response.editorHTML);
                        jQuery("#listEditor").addClass("windowModal");
                        jQuery("#listEditor").fadeIn();
                    }
                    else {
                        errorFunction(response);
                    }
                };

                // Handling für fehlerhaften Request
                errorFunction = function (response) {
                    showModalBox("Es ist ein Fehler aufgetreten.", response.message);
                    hideLoadingSpinner();
                };

                // Ajax aufrufen
                fireAjax(url, data, successFunction, errorFunction);

            });

            // Mehr...-Menü anzeigen bzw. ausblenden
            jQuery(".moreDots").mouseenter(function () {
                jQuery("#" + this.id + ".moreMenu").fadeIn();
            });

            jQuery(".moreDots").mouseleave(function () {
                // Alle Menüs ausblenden
                jQuery(".moreMenu").hide();
            });

        });


    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>