<?php

use App\Http\Controllers\UserController;

$followUpsToday = $user->operator->followUpsTempus();
$followUpsTodayCnt = count($followUpsToday);

// Logo
$path = "/images/ktkmouldtec_logo.png";
?>
<nav class="navbar navbar-expand-lg navbar-light">
    <a class="navbar-brand" href="<?php echo e(route('index')); ?>"><img src="<?php echo e($path); ?>" alt=""
                                                             style="width:80px;"></a>

    <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent"
            aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
        <i class="fas fa-bars"></i>
    </button>

    <div class="collapse navbar-collapse" id="navbarSupportedContent">
        <ul class="navbar-nav mr-auto">
            <?php if(UserController::checkRight("seeOrdersList", $user)): ?>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('projects.list')); ?>">
                        Projekte
                    </a>
                </li>
            <?php endif; ?>
            <?php if(UserController::checkRight("seeCustomersList", $user)): ?>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('customer.list')); ?>">
                        Kunden
                    </a>
                </li>
            <?php endif; ?>







            <?php if(UserController::checkRight("seeCustomersList", $user)): ?>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('operatinginstructions.list')); ?>">
                        Arbeitsanweisungen
                    </a>
                </li>
            <?php endif; ?>
            <?php if(UserController::checkRight("seeCustomersList", $user)): ?>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('proceduralinstructions.list')); ?>">
                        Verfahrensanweisungen
                    </a>
                </li>
            <?php endif; ?>


            <?php if(UserController::hasAnyConfigurationRights($user)): ?>
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle" href="#" role="button" data-toggle="dropdown"
                       aria-haspopup="true" aria-expanded="false">
                        Konfiguration
                    </a>
                    <div class="dropdown-menu">

                        <?php if(UserController::hasAnyGeneralConfigurationRights($user)): ?>
                            <p class="dropdown-header">Stammdaten</p>




                            <?php if(UserController::checkRight("seeOperatorList", $user)): ?>

                                    <a class="dropdown-item" href="<?php echo e(route('operator.list')); ?>">
                                        Bearbeiter
                                    </a>

                            <?php endif; ?>
                            <div class="dropdown-divider"></div>
                        <?php endif; ?>

                        <?php if(UserController::hasAnyOrderConfigurationRights($user)): ?>
                            <p class="dropdown-header">Projekte</p>
                            <?php if(UserController::checkRight("seeOrderTypes", $user)): ?>
                                <a class="dropdown-item" href="<?php echo e(route('projectTypes.list')); ?>">Projekttypen
                                    verwalten</a>
                                    <a class="dropdown-item" href="<?php echo e(route('articleVariables.list')); ?>">Artikelvariablen verwalten</a>
                                    <a class="dropdown-item" href="<?php echo e(route('projectVariables.list')); ?>">Projektvariablen verwalten</a>
                            <?php endif; ?>













                        <?php endif; ?>














                    </div>
                </li>
            <?php endif; ?>















            <?php if(UserController::isClientAdmin($user)): ?>
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle" href="#" id="navbarAdmin" role="button"
                       data-toggle="dropdown"
                       aria-haspopup="true" aria-expanded="false">
                        Administrator
                    </a>
                    <div class="dropdown-menu" aria-labelledby="navbarAdmin">
                        <p class="dropdown-header">Mandantenverwaltung</p>
                        <?php if(UserController::isSuperAdmin($user)): ?>
                            <a class="dropdown-item" href="<?php echo e(route('superAdmin.newClient')); ?>">Neuen Mandanten
                                anlegen</a>
                        <?php endif; ?>
                        <a class="dropdown-item" href="<?php echo e(route('client.edit')); ?>">Stammdaten bearbeiten</a>
                        <div class="dropdown-divider"></div>
                        <p class="dropdown-header">User</p>
                        <a class="dropdown-item" href="<?php echo e(route('clientAdmin.newUser')); ?>">User anlegen</a>
                        <a class="dropdown-item" href="<?php echo e(route('clientAdmin.users')); ?>">Alle anzeigen</a>
                    </div>
                </li>
            <?php endif; ?>

        </ul>

        <div class="divider-horizontal d-lg-none"></div>


        <ul class="navbar-nav mr-right">

            <li class="nav-icon">
                <a href="<?php echo e(route('user.edit')); ?>"><i class="fal fa-cog d-none d-lg-block"></i> <span class="d-lg-none">Einstellungen</span></a>
            </li>












            <li class="nav-icon">
                <a class="" href="<?php echo e(route('logout')); ?>"
                   onclick="event.preventDefault();
                   document.getElementById('logout-form').submit();">
                    <i class="fal fa-sign-out d-none d-lg-block"></i> <span class="d-lg-none">Logout</span>
                </a>

                <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST"
                      style="display: none;">
                    <?php echo csrf_field(); ?>
                </form>
            </li>
        </ul>

        <div class="divider-horizontal d-lg-none"></div>

        <div class="d-lg-none">
            <div class="userName">
                Eingeloggt als <strong><?php echo e($user->getName()); ?></strong>
            </div>
        </div>


    </div>
    <div class="divider-vertical d-none d-lg-block"></div>

    <div class="nav-user-img" style="background-image: url('<?php echo e($user->getImage()); ?>');">
    </div>

    <ul class="navbar-nav openUserNavCard">
        <li class="nav-item dropdown nav-user">
            <a class="nav-link dropdown-toggle" href="#" id="navbarUsercard" role="button" data-toggle="dropdown"
               aria-haspopup="true" aria-expanded="false">
                <?php echo e($user->getName()); ?>

            </a>
            <div class="dropdown-menu dropdown-menu-right" aria-labelledby="navbarUsercard">
                <div class="dropdown-item userNavCard">

                    <div class="row">
                        <div class="col-3">
                            <div class="navCard-user-img"
                                 style="background-image: url('<?php echo e($user->getImage()); ?>');"></div>
                        </div>
                        <div class="col-9 p-0">
                            <div class="userName">
                                <?php echo e($user->getName()); ?>

                            </div>
                            <div class="userEmail">
                                <?php echo e($user->email); ?>

                            </div>
                            <div>
                                <a href="<?php echo e(route('user.edit')); ?>">Profil & Einstellungen</a>
                            </div>
                        </div>
                    </div>

                    <div class="divider-horizontal"></div>

                    <div class="row">
                        <div class="col-md-4">
                            <a class="dropdown-item userNavCardFooter" href="<?php echo e(route('logout')); ?>"
                               onclick="event.preventDefault();
                   document.getElementById('logout-form').submit();">
                                <?php echo e(__('Logout')); ?>

                            </a>

                            <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST"
                                  style="display: none;">
                                <?php echo csrf_field(); ?>
                            </form>
                        </div>
                    </div>
                </div>
            </div>

        </li>
    </ul>

</nav>
<?php /**PATH E:\Projekte\KTK\ktkmouldtec\resources\views/layouts/nav.blade.php ENDPATH**/ ?>