<?php
use App\Library\DropzoneMulti;
use App\Http\Controllers\UserController;
use App\User;

$projectDocumentDropzoneList = [];
?>

<div class="col-12">
    <div class="row no-gutters" data-itable='1'>
        <div class="col-12">
            <div class="row no-gutters listHeader">
                <div class="col-5">
                    Dokument
                </div>
                <div class="col-1">
                    Größe
                </div>
                <div class="col-2">
                    Versionshinweis
                </div>
                <div class="col-3">
                    Neue Version
                </div>
                <div class="col-1">
                    Aktionen
                </div>
            </div>
        </div>
        <div class="col-12">
            <div id="<?php echo e($dropzone->formID); ?>-container">
                <?php $__currentLoopData = $documentList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $document): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                    <?php

                        $projectDocumentDropzone = null;

                        if(isset($document))
                        {
                            $projectDocumentDropzone = new DropzoneMulti(
                                $dropzoneOptions,
                                $dropzone->relatedForm,
                                "documentVersionDropzone_" . $document->id,
                                "default", true, "fas fa-file",
                                "newDocumentVersion_" . $document->id,
                                $document->id
                            );
                            array_push($projectDocumentDropzoneList, $projectDocumentDropzone);
                        }

                    ?>

                    <div class="row no-gutters listItem" data-documentId="<?php echo e($document->id); ?>">
                        <div class="col-5 col-document">
                            <?php if(substr( strrchr($document->title, '.'), 1) == "xlsx"): ?>
                                <i class="fas fa-file-excel fa-7x" style=";color:#282d67;"></i>
                            <?php elseif(substr( strrchr($document->title, '.'), 1) == "docx"): ?>
                                <i class="fas fa-file-word fa-7x" style=";color:#282d67;"></i>
                            <?php elseif(substr( strrchr($document->title, '.'), 1) == "pptx"): ?>
                                <i class="fas fa-file-powerpoint fa-7x" style=";color:#282d67;"></i>
                            <?php endif; ?>
                            <div class="col-document-information">
                                <?php echo e($document->title); ?>

                                <br>
                                <span class="badge badge-success new-version-info-field" style="padding:5px; display:none;">Neue Version</span>
                            </div>

                        </div>
                        <div class="col-1 col-document">
                            
                            <?php echo e(round($document->latest_revision()->size / 1024)); ?> KB
                        </div>
                        <div class="col-2 col-document">
                            <div>
                                <input type="input" style="width:80%;" class="form-control"/><br>
                                <span class="badge badge-light version-info" style="padding:5px;color:lightgray" data-version="<?php echo e($document->latest_revision()->version); ?>">Version <?php echo e($document->latest_revision()->version); ?></span>
                            </div>
                        </div>
                        <div class="col-3 col-document">
                            <?=$projectDocumentDropzone->getDropzoneForm()?>
                        </div>
                        <div class="col-1 col-document">
                            <div class="row no-gutters">
                                <div class="">
                                    <a href="<?php echo e(route("download.documentRevision", [ $document->latest_revision()->id ])); ?>"
                                       data-documentRevisionId="<?php echo e($document->latest_revision()->id); ?>"
                                       class="downloadDocumentRevision"
                                       title="Download">
                                        <i class="fal fa-download"></i>
                                    </a>
                                </div>

                                <div class="">
                                    <a href="#"
                                       data-projecttypeid=""
                                       class="deleteProjectType"
                                       title="Löschen">
                                        <i class="fal fa-trash-alt"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?=$projectDocumentDropzone->getDropzoneJSCode()?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            </div>
            <div  style="margin-top:25px;"></div>
            <?php
            echo $dropzone->getDropzoneForm();
            ?>
        </div>
    </div>
</div>

<?php
echo $dropzone->getDropzoneJSCode();
?>
<script>
    jQuery(document).ready(function(){
        <?php $__currentLoopData = $projectDocumentDropzoneList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $projectDocumentDropzone): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?=$projectDocumentDropzone->formID?>.dropzone.on("success", function(file)
            {
                jQuery(file.previewElement).animate({
                    opacity: 0,
                    marginLeft: "-650px",
                    height: "40px"
                }, 750, "swing", function(){
                    jQuery(this).remove();
                    var newInfo = jQuery('[data-documentId="<?php echo e($projectDocumentDropzone->documentId); ?>"] .new-version-info-field');
                    var versionInfo = jQuery('[data-documentId="<?php echo e($projectDocumentDropzone->documentId); ?>"] .version-info');
                    newInfo.fadeIn();
                    versionInfo.removeClass("badge-light");
                    versionInfo.removeClass("badge-success");
                    newInfo.removeClass("badge-success");

                    setTimeout(function() {
                        versionInfo.addClass("badge-success");
                        newInfo.addClass("badge-success");
                        versionInfo.css("color", "white");
                        versionInfo.data("version", versionInfo.data("version") + 1);
                        versionInfo.text("Version " + versionInfo.data("version"));
                    }, 1);

                });
            });
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    });
</script>


<script>

    jQuery(document).ready(function(){

        <?=$dropzone->formID?>.dropzone.on("success", function(file)
        {
            var elem = document.createElement('div');
            var iconClass = "";
            jQuery(elem).attr("class", "row no-gutters listItem");

            if(file.type == "application/vnd.openxmlformats-officedocument.presentationml.presentation")
            {
                iconClass = "fa-file-powerpoint"
            }
            else if (file.type == "application/vnd.openxmlformats-officedocument.wordprocessingml.document")
            {
                iconClass = "fa-file-word";
            }
            else if (file.type == "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet")
            {
                iconClass = "fa-file-excel";
            }

            var docElement = `
                    <div class="col-5 col-document">
                        <i class="fas ${iconClass} fa-7x" style=";color:#282d67;"></i>
                        <div class="col-document-information">
                            ${file.name}
                            <br>
                            <span class="badge badge-success" style="padding:5px;">Neues Dokument</span>
                        </div>
                    </div>
                    <div class="col-1 col-document">
                        ${Math.round(file.size / 1024)} KB
                    </div>
                    <div class="col-2 col-document">
                        <div>
                            <input type="input" style="width:80%;" class="form-control"/>
                            <br>
                            <span class="badge badge-success" style="padding:5px;">Version 1</span>
                        </div>
                    </div>
                    <div class="col-3 col-document">
                    </div>
                    <div class="col-1 col-document">
                        <div class="row no-gutters">
                            <div class="">
                                <a href="/downloadTmpFile/${file.upload.filename}"
                                   data-tmpPath="${file.upload.filename}"
                                   class="editProjectType"
                                   title="Download">
                                    <i class="fal fa-download"></i>
                                </a>
                            </div>

                            <div class="">
                            <a href="#"
                                   class="deleteProjectType"
                                   title="Löschen">
                                    <i class="fal fa-trash-alt"></i>
                                </a>
                            </div>
                        </div>
                    </div>
                `;

            jQuery(file.previewElement).animate({
                opacity: 0,
                marginTop: "-150px",
                width: "0px"
            }, 750, "swing", function(){
                jQuery(this).remove();
            });
            jQuery(elem).html(docElement);
            jQuery(elem).attr("style", "opacity:0; height:0px;padding:0px;");
            jQuery(elem).animate({
                opacity: 1,
                height: "130px",
                padding:"15px",
            }, 750, "swing");

            jQuery('#<?php echo e($dropzone->formID); ?>-container').append(elem);
        });
    });

    // function downloadTmpFile(filePath)
    // {
    //     var token = jQuery('meta[name="csrf-token"]').attr('content');
    //     jQuery.ajaxSetup({
    //         headers: {
    //             'X-CSRF-TOKEN': token
    //         }
    //     });
    //
    //     jQuery.post({
    //         type: "POST",
    //         url: "/downloadTmpFile",
    //         data: {"filename" : filePath},
    //     });
    // }
</script><?php /**PATH E:\Projekte\KTK\ktkmouldtec\resources\views/document/documentList.blade.php ENDPATH**/ ?>