<?php echo BootForm::open(["id" => "changeUserRights",
                   "route" => array('clientAdmin.changeUserRights'),
                   "method" => "POST",
                   "enctype" => "multipart/form-data"]); ?>

<input type="hidden" name="userToEdit" value="<?php echo e($userToEdit->id); ?>">

<header>Rechte bearbeiten: <?php echo e($userToEdit->getName()); ?></header>


<div class="container">
    <ul class="nav nav-tabs" id="rightsGroupsTab" role="tablist">
        <?php $__currentLoopData = $rightsGroups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rightsGroupKey => $rightsGroup): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <li class="nav-item">
                <a class="nav-link <?php if($loop->first): ?> active <?php endif; ?>" id="<?php echo e($rightsGroupKey); ?>-tab" data-toggle="tab"
                   href="#tab<?php echo e($rightsGroupKey); ?>" role="tab" aria-controls="<?php echo e($rightsGroupKey); ?>"
                   aria-selected="true"><?php echo e($rightsGroup["name"]); ?></a>
            </li>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </ul>


    <div class="tab-content" id="rightsGroupsTabContent">
        <?php echo csrf_field(); ?>
        <?php $__currentLoopData = $rightsGroups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rightsGroupKey => $rightsGroup): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="tab-pane fade <?php if($loop->first): ?> show active <?php endif; ?>" id="tab<?php echo e($rightsGroupKey); ?>"
                 role="tabpanel" aria-labelledby="<?php echo e($rightsGroupKey); ?>-tab">

                <div class="row no-gutters rightsGroupMaster">
                    <div class="col-9">
                        <div class="row">
                            <div class="col-12 rightsGroupName">
                                <?php echo e($rightsGroup["name"]); ?>

                            </div>
                        </div>

                        <div class="row">
                            <div class="col-12 rightsGroupDesc">
                                <?php echo e($rightsGroup["description"]); ?>

                            </div>
                        </div>
                    </div>


                    
                    <?php if(sizeof($rightsGroup["rights"]) > 1): ?>
                        <div class="col-2 offset-1">
                            <label class="toggleCheckbox">
                                <input type="checkbox" class="masterCheckbox"
                                       name="<?php echo e($rightsGroupKey); ?>" <?php echo e($rightsGroup["hasAllRights"]); ?>>
                                <i class="bigger"></i>
                            </label>
                        </div>

                    <?php endif; ?>
                </div>

                <div class="row">
                    <div class="col-md-12">
                        <?php $__currentLoopData = $rightsGroup["rights"]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rightKey => $right): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="row align-items-center right">
                                <div class="col-10">
                                    <div class="row rightName">
                                        <?php echo e($right["label"]); ?>

                                    </div>
                                    <div class="row rightDesc">
                                        <?php echo e($right["description"]); ?>

                                    </div>
                                </div>
                                <div class="col-2">
                                    <label class="toggleCheckbox <?php echo e($rightsGroupKey); ?>">
                                        <input type="checkbox" name="checkbox_<?php echo e($rightKey); ?>"
                                                <?php echo e($right["hasRight"]); ?>>
                                        <i></i>
                                    </label>
                                </div>

                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>

    <div class="row"><p></p></div>
</div>


<footer>
    <div class="form-group row align-items-center">
        <div class="col-6 text-left">
            <button type="button" id="closeListEditorButton" class="btn btn-secondary">
                Abbrechen
            </button>
        </div>

        <div class="col-6 text-right">
            <button type="submit" class="btn btn-primary">
                Speichern
            </button>
        </div>
    </div>
</footer>


<script>
    jQuery(function () {
        // Globale Checkbox zum aus-/abwählen aller Rechte in der Gruppe
        jQuery(".masterCheckbox").click(function () {
            jQuery("." + this.name + " input[type='checkbox']").attr("checked", jQuery(this).prop("checked"));
        });

        // Bei zuweisen/wegnehmen von Mandantenadministrationsrechten auch alle anderen Checkboxen aktivieren/deaktivieren
        jQuery("input[name='checkbox_2']").click(function () {
            jQuery("#rightsGroupsTabContent input[type='checkbox'][name!='checkbox_1']").attr("checked", jQuery(this).prop("checked"));
        });

        jQuery("input[name='checkbox_1']").click(function () {
            jQuery("#rightsGroupsTabContent input[type='checkbox'][name!='checkbox_1']").attr("checked", jQuery(this).prop("checked"));
        });

    });
</script>

<?php echo BootForm::close(); ?>