<?php
use App\Http\Controllers\UserController;
use Carbon\Carbon;
use App\Library\DropzoneMulti;


$orderDocumentsDropzoneOptions = [
    'acceptedFiles' => '"image/*,application/pdf,application/msword,application/vnd.ms-powerpoint,application/vnd.ms-excel,.xlsx,.xls,.doc,.docx,.ppt,.pptx,.msg"',
    'maxFilesize' => 15,
    'maxFiles' => 15
];

$orderDocumentsDropzone = new DropzoneMulti(
    $orderDocumentsDropzoneOptions,
    "createOrder",
    "orderDocumentsDropzone",
    "default", true, "fas fa-file"
);

# Endtermin / Exporttermin bestimmen
$now = new Carbon();
$then = clone $now->addDays(28);
if ($then->isWeekend())
    $then->nextWeekDay();

?>

<?php $__env->startSection('content'); ?>
    <main class="contentContainer">
        <h1>Projekt anlegen</h1>
        <button type="button" class="btn btn-primary btn-big additionalOrderSubmit"
                style="position: absolute; right: 10px; top: 10px;">
            Zur Artikelanlage
        </button>


        <?php echo BootForm::open(["id" => "createOrder",
                             "route" => "projects.store",
                             "method" => "POST",
                             "enctype" => "multipart/form-data"]);; ?>



        <div class="row no-gutters listHeader">
            <div class="col-12">Grunddaten</div>
        </div>

        <div class="row">
            <div class="col-6">
                <div class="form-group">
                    <label for="customer_id" class="col-12 col-form-label"><h5>Kundenzuordnung</h5></label>
                    <div class="col-12">
                        <div class="customerList">
                            <div class="row customerListControls">
                                <div class="col-6">
                                    <div class="searchCustomer">
                                        <input type="text" class="slide-input search" id="searchFor" autocomplete="off"
                                               data-shownosearchresults="noOrderCustomers">
                                    </div>
                                </div>
                                <div class="col-6 text-right">
                                    <?php if(UserController::checkRight("createCustomers", $user)): ?>
                                        <label for="plusButton" title="Kunden hinzufügen" id="createNewCustomer">
                                            <i class="fas fa-plus-circle"></i></label>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div id="customerList">
                                <?php $__currentLoopData = $customerList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="customerItem searchItem"
                                         data-search-for="<?php echo e($customer->company); ?>">
                                        <label class="radio">
                                            <?php echo e($customer->company); ?><?php if($customer->place != ""): ?>, <?php echo e($customer->place); ?><?php endif; ?>
                                            <input type="radio" name="customer_id" value="<?php echo e($customer->id); ?>">
                                            <div class="indicator"></div>
                                        </label>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>

                            <div data-nosearchresults="noOrderCustomers">Für diese Sucheingabe gibt es leider keine Ergebnisse.</div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-6">
                <div class="form-group">
                    <label for="responsible_operator_id" class="col-12 col-form-label"><h5>Verantwortliche
                            Bearbeiter</h5>
                    </label>
                    <div class="col-12">
                        <div class="inlineList">
                            <?php $__currentLoopData = $operatorsList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $operator): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="inlineListValue" data-operatorid="<?php echo e($operator->id); ?>">
                                    <div>
                                        <label class="checkbox"><?php echo e($operator->getName()); ?>

                                            <input type="checkbox"
                                                   <?php if($operator->id == $user->id): ?>
                                                   checked="checked"
                                                   <?php endif; ?>
                                                   name="responsibleOperators[<?php echo e($operator->id); ?>]"
                                            >
                                            <span class="checkmark"></span>
                                        </label>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>

            </div>
        </div>

        <div class="row">
            <div class="col-12 col-lg-6">
                <div class="row">
                    <div class="col-12">
                        <div class="form-group">
                            <label for="project_type_id" class="col-12 col-form-label"><h5>Projekttyp</h5></label>
                            <div class="col-12">
                                <select class="form-control" id="project_type_id" name="project_type_id">
                                    <option value="" disabled selected>Bitte auswählen</option>
                                    <?php $__currentLoopData = $projectTypeList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $projectType): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($projectType->id); ?>"
                                                ><?php echo e($projectType->title); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">

                </div>
            </div>

        </div>

        <?php echo BootForm::close(); ?>



        <div class="row">&nbsp;</div>

        <div class="row">
            <div class="col-12 text-right">
                <button type="button" class="btn btn-primary btn-big additionalOrderSubmit" style="margin-right:10px;">
                    Zur Artikelanlage
                </button>
            </div>
        </div>
    </main>

    <?php echo $__env->make('layouts.overlay', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


    <?php
    echo $orderDocumentsDropzone->getDropzoneJSCode();
    ?>
    <script>
        jQuery(document).ready(function () {

            // Bei Ändern des Auftragstyps...
            // - Auftragskennzeichen einblenden und sortieren
            // - Auftragsstatus vorbelegen
            jQuery("select#order_type_id").change(function () {

                // Auftragstyp lesen
                let selectedOrderType = parseInt(jQuery("select#order_type_id").val());

                // Auftragskennzeichen einblenden und sortieren
                jQuery(".chooseType").hide();
                jQuery(".orderTagHeader").show();
                jQuery("#orderTagsForOrderType").show();
                jQuery("#otherOrderTags").show();
                jQuery(".orderTagsValueList").fadeIn();

                // Container leeren
                // "Keine Kennzeichen vorhanden" wieder einblenden
                jQuery("#orderTagsForOrderType > div.tagList").html("");
                jQuery("#otherOrderTags > div.tagList").html("");

                jQuery("#orderTagsForOrderType > div.noTags").show();
                jQuery("#otherOrderTags > div.noTags").show();

                // Alle Auftragskennzeichen aus unsichtbarer Liste auslesen
                jQuery("div.orderTagsList > div.orderTagValue").each(function () {
                    // Auftragstyp auslesen
                    let orderType = parseInt(jQuery(this).data("ordertype"));

                    // Zuordnen
                    if (orderType == selectedOrderType) {
                        jQuery("#orderTagsForOrderType > div.noTags").hide();
                        jQuery("#orderTagsForOrderType > div.tagList").append($(this).clone());
                    }
                    // Restliche Auftragskennzeichen unter "Weitere Kennzeichen" einsortieren
                    else {
                        jQuery("#otherOrderTags > div.noTags").hide();
                        jQuery("#otherOrderTags > div.tagList").append($(this).clone());
                    }
                });


                // Auftragsstatus vorselektieren
                // Startstatus des Auftragstypes auslesen
                let option = jQuery("select#order_type_id option[value='" + selectedOrderType + "']");
                let orderStartStatus = jQuery(option).data("orderstatus");

                // Startstatus des Auftragstyps vorselektieren, alle anderen deselektieren
                jQuery("select#order_status_id").find("option").prop("selected", false);
                jQuery("select#order_status_id").find("option[value='" + orderStartStatus + "']").prop("selected", true);
            });

            // Neuen Auftraggeber anlegen
            jQuery("#createNewCustomer").click(function () {
                showLoadingSpinner();
                let url = "/customer";
                let customer_id = 0;

                $.get(url + '/' + customer_id, function (data) {

                    if (data.response == "success") {
                        jQuery("#loadingSpinner").hide();
                        jQuery("#editorContent").html(data.editorHTML);
                        jQuery("#listEditor").addClass("windowWide");
                        jQuery("#listEditor").fadeIn();
                    }
                    else {
                        showModalBox("Es ist ein Fehler aufgetreten.");
                        hideLoadingSpinner();
                    }
                });

            });

            // Kalender öffnen um Termin auszuwählen
            jQuery("#openCalendar").click(function () {
                showLoadingSpinner();
                var url = "/operator/calendar/summarylayer";

                // Request new Calendar
                jQuery.ajax({
                    method: 'GET',
                    url: url,
                    data: {
                        'callback': 'setAppointmentFromCalendarLayer'
                    },
                    success: function (data) {
                        jQuery("#loadingSpinner").hide();
                        jQuery("#editorContent").html(data);
                        jQuery("#listEditor").addClass("windowWide");
                        jQuery("#listEditor").fadeIn();
                        specialResize();
                    },
                    error: function (jqXHR, textStatus, errorThrown) {
                        showModalBox("Es ist ein Fehler aufgetreten.");
                    }
                });
            });


            // Adresse hinzufügen
            jQuery("#addAddress").click(function () {
                showLoadingSpinner();
                let url = "/orders/new/addAddress";
                let address_id = 0;

                $.get(url + '/' + address_id, function (data) {

                    if (data.response == "success") {
                        jQuery("#loadingSpinner").hide();
                        jQuery("#editorContent").html(data.editorHTML);
                        jQuery("#listEditor").addClass("windowWide");
                        jQuery("#listEditor").fadeIn();
                    }
                    else {
                        showModalBox("Es ist ein Fehler aufgetreten.");
                        hideLoadingSpinner();
                    }
                });
            });
        });

        // Adresseingaben verarbeiten
        jQuery(document).on('click', 'button#editOrderAddress', function () {

            // Eingabe validieren
            if (!jQuery("form#editOrderAddress").valid()) {
                showModalBox("Validierungsfehler", "Bitte Eingaben überprüfen.")
                return;
            }

            // Editierkennzeichen lesen
            let edit = jQuery("input#addressEdit").val();

            // Daten für eine neue Adresse aus dem Overlay holen und als JSON-Objekt speichern
            let newAddress = {};

            newAddress.name = jQuery("input#address_name").val();
            newAddress.firstname = jQuery("input#address_firstname").val();
            newAddress.company = jQuery("input#address_company").val();
            newAddress.street = jQuery("input#address_street").val();
            newAddress.house_number = jQuery("input#address_house_number").val();
            newAddress.address_addendum = jQuery("input#address_address_addendum").val();
            newAddress.zipcode = jQuery("input#address_zipcode").val();
            newAddress.place = jQuery("input#address_place").val();
            newAddress.country = jQuery("input#address_country").val();
            newAddress.telephone_number = jQuery("input#address_telephone_number").val();
            newAddress.note = jQuery("textarea#address_note").val();
            newAddress.email_final_customer = jQuery("input#address_email_final_customer").val();

            let jsonString = JSON.stringify(newAddress);

            let newIndex = 0;

            if (edit === "true") {
                let addressID = jQuery("input#addressID").val();

                // Bestehendes Input mit dieser Adress-ID löschen
                jQuery("input[data-addressindex='" + addressID + "']").remove();

                // Listeneintrag löschen
                jQuery("div.listItem[data-addressindex='" + addressID + "']").remove();

                newIndex = addressID;
            }
            else {
                // Letzten Adressindex finden
                let i = 0;

                jQuery("#addressInputsHidden > input[data-addressindex]").each(function () {
                    if (i <= jQuery(this).data("addressindex")) {
                        i = jQuery(this).data("addressindex");
                    }
                });

                // Neuen Index bestimmen
                newIndex = i + 1;
            }

            let newAddressInput = "<input type='hidden' data-addressindex='" + newIndex + "' " +
                "                         name='address[" + newIndex + "]' value='" + jsonString + "'>";

            // JSON-String in unsichtbarem Input hinzufügen
            jQuery("#addressInputsHidden").append(newAddressInput);

            // Adressenteaser für Liste bauen
            let addressTeaser = newAddress.name + " " + newAddress.firstname + "";
            if (newAddress.company !== "") {
                addressTeaser = addressTeaser + " (" + newAddress.company + ")";
            }
            addressTeaser = addressTeaser + ", " + newAddress.street + " " + newAddress.house_number + ", " +
                newAddress.zipcode + " " + newAddress.place;
            addressTeaser = addressTeaser + " (Tel.: " + newAddress.telephone_number + ")";

            // Adresse zur Liste hinzufügen
            let addressItem = '<div class="row no-gutters align-items-center listItem" data-addressindex="' + newIndex + '"> \n' +
                '                            <div class="col-10">\n' +
                addressTeaser +
                '                            </div>\n' +
                '\n' +
                '                            <div class="col-1 offset-1">\n' +
                '                                <div class="row no-gutters">\n' +
                '                                    <div class="col-md-6">\n' +
                '                                        <a href="#"\n' +
                '                                           data-addressindex="' + newIndex + '"\n' +
                '                                           class="editAddress"\n' +
                '                                           title="Bearbeiten">\n' +
                '                                            <i class="fal fa-pencil-alt"></i>\n' +
                '                                        </a>\n' +
                '                                    </div>\n' +
                '                                </div>\n' +
                '                            </div>\n' +
                '                        </div>';

            jQuery("#closeListEditor").trigger("click");

            jQuery("#noListEntries").fadeOut();

            jQuery("#addressListItems").append(addressItem);
        });

        // Adresse bearbeiten
        jQuery(document).on('click', '.editAddress', function () {

            let addressID = jQuery(this).data("addressindex");

            showLoadingSpinner();
            let url = "/orders/new/addAddress";
            let address_id = 0;

            $.get(url + '/' + address_id, function (data) {

                if (data.response == "success") {
                    jQuery("#loadingSpinner").hide();
                    jQuery("#editorContent").html(data.editorHTML);

                    // Editierkennzeichen, Adressen-ID und Löschfeld setzen
                    jQuery("input#addressEdit").val("true");
                    jQuery("input#addressID").val(addressID);
                    jQuery("button#deleteOrderAddress").data("addressindex", addressID);

                    // Daten aus zugehörigem Input holen
                    let jsonAddressData = jQuery("input[data-addressindex='" + addressID + "']").val();
                    let addressData = JSON.parse(jsonAddressData);

                    // Felder vorbelegen
                    jQuery("input#address_name").val(addressData.name);
                    jQuery("input#address_firstname").val(addressData.firstname);
                    jQuery("input#address_company").val(addressData.company);
                    jQuery("input#address_street").val(addressData.street);
                    jQuery("input#address_house_number").val(addressData.house_number);
                    jQuery("input#address_address_addendum").val(addressData.address_addendum);
                    jQuery("input#address_zipcode").val(addressData.zipcode);
                    jQuery("input#address_place").val(addressData.place);
                    jQuery("input#address_country").val(addressData.country);
                    jQuery("input#address_telephone_number").val(addressData.telephone_number);
                    jQuery("input#address_note").val(addressData.note);
                    jQuery("input#address_email_final_customer").val(addressData.email_final_customer);

                    jQuery("#listEditor").addClass("windowWide");
                    jQuery("#listEditor").fadeIn();
                }
                else {
                    showModalBox("Es ist ein Fehler aufgetreten.");
                    hideLoadingSpinner();
                }
            });
        });

        // Adresse löschen
        jQuery(document).on('click', 'button#deleteOrderAddress', function () {
            let addressID = jQuery(this).data("addressindex");

            // Input mit dieser Adress-ID löschen
            jQuery("input[data-addressindex='" + addressID + "']").remove();

            // Listeneintrag löschen
            jQuery("div.listItem[data-addressindex='" + addressID + "']").remove();
            jQuery("#closeListEditor").trigger("click");
        });

        function setAppointmentFromCalendarLayer(data) {

            // Input in DIV für neue Termine hinzufügen
            let appointment = {operatorId: data.operatorid, appointmentDate: data.dateAppointment};

            // Letzten Index auslesen
            let i = 0;

            jQuery("[data-appointmentindex]").each(function () {
                if (i <= jQuery(this).data("appointmentindex")) {
                    i = jQuery(this).data("appointmentindex");
                }
            });

            // Neuen Index bestimmen
            newIndex = i + 1;

            let newInput = '<input type="hidden" name="newAppointments[' + newIndex + ']" ' +
                '                                id="appointmentsToDelete"\n' +
                '                                data-appointmentindex="' + newIndex + '"\n' +
                '                                value=\'' + JSON.stringify(appointment) + '\'>';


            jQuery("#appointmentInputsHidden").append(newInput);

            // Zeitstempel formatieren
            let appointmentFormatted = formatUNIXTimestampToDate(appointment.appointmentDate);

            // In Liste für Termine vorblenden
            let newListEntry = '<div class="row no-gutters listItem orderAppointment"\n' +
                '                                 data-appointmentindex="' + newIndex + '">\n' +
                '\n' +
                '                                <div class="col-6">\n' +
                '                                    ' + data.operatorName + '\n' +
                '                                </div>\n' +
                '                                <div class="col-4">\n' +
                '                                    ' + appointmentFormatted + '\n' +
                '                                </div>\n' +
                '                                <div class="col-2 text-right">\n' +
                '                                    <a class="deleteOrderAppointment"\n' +
                '                                       data-appointmentindex="' + newIndex + '"\n' +
                '                                       data-appointmentexisted="false"\n' +
                '                                    ><i class="fas fa-trash-alt"></i></a>\n' +
                '                                </div>\n' +
                '\n' +
                '                            </div>';

            jQuery("#orderAppointments").append(newListEntry);

            jQuery("#orderAppointments #noListEntries").fadeOut();

            jQuery("#listEditor").removeClass();
            jQuery("#listOverlay").hide();
        }


        // Auftragstermin löschen
        jQuery(document).on('click', 'a.deleteOrderAppointment', function () {

            let appointmentId = jQuery(this).data("appointmentindex");

            // Input-Feld löschen
            jQuery("input[data-appointmentindex='" + appointmentId + "']").remove();

            // In Liste ausblenden
            jQuery("div.listItem[data-appointmentindex='" + appointmentId + "']").fadeOut();
        });

        // Duplikatsprüfung
        jQuery(".additionalOrderSubmit").click(function () {
            showLoadingSpinner();

            let url = "/orders/duplicate";

            // Ajax-Request für das Nachladen des Overlay-Forms vorbereiten
            var token = jQuery('meta[name="csrf-token"]').attr('content');
            jQuery.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': token
                }
            });

            $.post(url, jQuery("#createOrder").serialize(), function (data) {
                if (data.response == "error") {
                    jQuery("#loadingSpinner").hide();
                    jQuery("#editorContent").html(data.editorHTML);
                    jQuery("#listEditor").addClass("windowNarrow");
                    jQuery("#listEditor").fadeIn();
                }
                else {
                    if (data.response != "duplicateExists")
                    {
                        jQuery("#createOrder").submit();
                        hideLoadingSpinner();
                    }
                    else
                    {
                        jQuery("#loadingSpinner").hide();
                        jQuery("#editorContent").html(data.editorHTML);
                        jQuery("#listEditor").addClass("windowNarrow");
                        jQuery("#listEditor").fadeIn();
                    }
                }
            });
        });

    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\Projekte\KTK\ktkmouldtec\resources\views/project/create.blade.php ENDPATH**/ ?>