<?php
use App\Http\Controllers\UserController;

$arr = array();
$arr["customer"] = 5; #dd(serialize($arr));

$ser = serialize($arr);
?>

<?php $__env->startSection('content'); ?>
    <main class="contentContainer">

        <h1>Kunden</h1>
        <div class="row">
            <div class="col-md-12">
                <div class="row">
                    <div class="col-12 col-md-3 text-center">
                        <?php if(UserController::checkRight("createCustomers", $user)): ?>
                            <a class="button editCustomer"
                               href="#"
                               data-customerid="0">Neuen Kunden
                                anlegen</a>
                        <?php endif; ?>
                    </div>
                    <div class="col-12 col-md-3 offset-md-6 text-right">
                        <?php if(count($customerList) > 0): ?>
                            <input type="text" class="slide-input search" id="searchFor" autocomplete="off"
                                   data-shownosearchresults="noCustomers">
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>

        <div class="clearfix">&nbsp;</div>

        <div class="row no-gutters" id="customerList" data-itable='1'>
            <div class="col-12">
                <div class="row no-gutters listHeader">
                    <div class="col-1">
                        Nr.
                    </div>
                    <div class="col-5">
                        Kunde
                    </div>
                    <div class="col-4">
                        Kontakt
                    </div>
                    <div class="col-2">
                        Aktionen
                    </div>
                </div>
                <?php if(count($customerList) > 0): ?>
                    <?php $__currentLoopData = $customerList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="row no-gutters align-items-center listItem searchItem"
                             data-search-for="<?php echo e($customer->company); ?> <?php echo e($customer->name); ?> <?php echo e($customer->firstname); ?>">

                            <div class="col-1">
                                <a data-customerid="<?php echo e($customer->id); ?>"
                                   class="editCustomer cursorPointer"
                                   title="Bearbeiten">
                                    <?php echo e($customer->customer_number); ?>

                                </a>
                            </div>

                            <div class="col-5 label">
                                <a data-customerid="<?php echo e($customer->id); ?>"
                                   class="editCustomer cursorPointer"
                                   title="Bearbeiten">
                                    <?php echo e($customer->company); ?><?php if($customer->place != ""): ?>, <?php echo e($customer->place); ?><?php endif; ?>
                                </a>
                            </div>

                            <div class="col-4">
                                <div class="row">
                                    <div class="">
                                        <?php if($customer->name != "" && $customer->email != ""): ?>
                                            <a href="mailto:<?php echo e($customer->email); ?>"><?php echo e($customer->title); ?> <?php echo e($customer->firstname); ?> <?php echo e($customer->name); ?></a>
                                        <?php elseif($customer->name != "" && $customer->email == ""): ?>
                                            <?php echo e($customer->title); ?> <?php echo e($customer->firstname); ?> <?php echo e($customer->name); ?>

                                        <?php elseif($customer->name == "" && $customer->email != ""): ?>
                                            <a href="mailto:<?php echo e($customer->email); ?>"><?php echo e($customer->email); ?></a>
                                        <?php else: ?>
                                            -
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="">
                                        <?php if($customer->telephone_number != ""): ?>
                                            Tel.: <?php echo e($customer->telephone_number); ?>

                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>


                            <div class="col-2">
                                <div class="row no-gutters">


                                    <div class="">
                                        <?php if(UserController::checkRight("editCustomers", $user)): ?>
                                            <a href="#"
                                               data-customerid="<?php echo e($customer->id); ?>"
                                               class="editCustomer"
                                               title="Bearbeiten">
                                                <i class="fal fa-pencil-alt"></i>
                                            </a>
                                        <?php endif; ?>
                                    </div>
                                    <div class="">
                                        <?php if(UserController::checkRight("seeOrdersList", $user)): ?>
                                            <a href="<?php echo e(route('orders.list', ["customerId" => $customer->id])); ?>"
                                               data-customerID="<?php echo e($customer->id); ?>"
                                               class="showCustomerOrderList"
                                               title="Auftragsliste anzeigen">
                                                <i class="fal fa-clipboard-list"></i>
                                            </a>
                                        <?php endif; ?>
                                    </div>
                                    <div class="">
                                        <?php if($customer->email != ""): ?>
                                            <a href="mailto:<?php echo e($customer->email); ?>"
                                               class="mailCustomer"
                                               title="E-Mail schreiben">
                                                <i class="fal fa-envelope"></i>
                                            </a>
                                        <?php endif; ?>
                                    </div>

                                </div>
                            </div>

                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                    <div class="row noListEntries">
                        <div class="col-12 text-center">
                            Keine Auftraggeber hinterlegt.
                        </div>
                    </div>
                <?php endif; ?>
                <div data-nosearchresults="noCustomers" class="row">
                    <div class="col-12 text-center">
                        Zu dieser Eingabe gibt es leider keine Ergebnisse. Bitte versuche es erneut.
                    </div>
                </div>
            </div>
        </div>
    </main>

    <?php echo $__env->make('layouts.overlay', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


    <script>

        jQuery(document).ready(function () {

            // Neuen Auftraggeber anlegen / Bestehenden bearbeiten
            jQuery(".editCustomer").click(function () {
                showLoadingSpinner();

                let url = "/customer";
                let customer_id = jQuery(this).data("customerid");

                $.get(url + '/' + customer_id, function (data) {

                    if (data.response == "success") {
                        jQuery("#loadingSpinner").hide();
                        jQuery("#editorContent").html(data.editorHTML);
                        jQuery("#listEditor").addClass("windowWide");
                        jQuery("#listEditor").fadeIn();
                    }
                    else {
                        error = true;
                        showModalBox("Es ist ein Fehler aufgetreten.", data.message);
                        hideLoadingSpinner();
                    }
                });
            });

        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\Projekte\KTK\ktkmouldtec\resources\views/customer/list.blade.php ENDPATH**/ ?>