<?php $__env->startSection('content'); ?>
    <?php
    use App\Library\Dropzone;

    # Dropzone initialisieren
    $hasImage = false;
    if ($user->image != null)
        $hasImage = true;

    $dropzoneOptions = array(
        "thumbnailWidth" => 93,
        "thumbnailHeight" => 93,
    );

    $dropzone = new Dropzone($dropzoneOptions,
        "userEdit",
        "userImageDropzone",
        "default",
        true, $user->getImage());
    ?>

    <main class="contentContainer">

        <h1>Profil & Einstellungen</h1>

        <div class="row profileSettingsContainer">

            <?php echo $__env->make('user.navEdit', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

            <section class="col-md-7 col-12 userData">

                <div class="row">
                    <div class="col-md-3">
                        <?php
                        echo $dropzone->getDropzoneForm();
                        ?>
                    </div>
                    <div class="col-md-9 align-self-center">
                        <div class="row userName">
                            <?php echo e($user->getName()); ?>

                        </div>
                        <div class="row userEmail">
                            <?php echo e($user->email); ?>

                            <a href="<?php echo e(route('user.changeEmail')); ?>">
                                <i class="fal fa-pencil-alt"></i>
                            </a>
                        </div>
                    </div>
                </div>

                <div class="row spacer-vertical"></div>

                <div class="row">
                    <div class="col-md-12">

                        <h2>Persönliche Daten</h2>
                        <?php echo BootForm::open(["id" => "userEdit",
                                           "route" => array('user.edit.update', $user->id),
                                           "method" => "POST",
                                           "enctype" => "multipart/form-data"]);; ?>


                        <?php if($hasImage): ?>
                            <input type="hidden" name="deleteImage" id="deleteImage" value="0">
                        <?php endif; ?>

                        <input type="hidden" name="relFile" value="<?php echo e(uniqid(null, true)); ?>">
                        <input type="hidden" name="hasImage" id="hasImage" value="<?php echo e($hasImage); ?>">
                        <input type="hidden" name="overrideImage" class="overrideImage" value="0">

                        <div class="form-group row">
                            <label for="name" class="col-md-2 col-form-label">Name</label>
                            <div class="col-md-10">
                                <input type="text" class="form-control" id="name" name="name" value="<?php echo e($user->name); ?>">
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="firstname" class="col-md-2 col-form-label">Vorname</label>
                            <div class="col-md-10">
                                <input type="text" class="form-control" id="firstname" name="firstname"
                                       value="<?php echo e($user->firstname); ?>">
                            </div>
                        </div>

                        <input type="hidden" name="deleteFile" value="0"> <br/>

                        <input type="hidden" name="newFile" value="">

                        <?php echo BootForm::submit(); ?>


                        <?php echo BootForm::close();; ?>

                    </div>
                </div>

            </section>

        </div>

    </main>

    <?php
    echo $dropzone->getDropzoneJSCode();
    ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>