<?php
$username = $operator->firstname . " " . $operator->name;
?>

<?php echo BootForm::open(["id" => "newUserConfirm",
                   "route" => array('clientAdmin.newUser', $operator->id),
                   "method" => "GET",
                   "enctype" => "multipart/form-data"]); ?>

<input type="hidden" name="operator" value="<?php echo e($operator->id); ?>">

<div>
    <header>Benutzer erstellen: <?php echo e($username); ?></header>

    <div class="container">

        <div class="row">
            <div class="col-md-12">
                <p>Beim Erstellen eines Benutzers wird an dessen hinterlegte E-Mail Adresse eine E-Mail mit Login-Informationen versendet. Im Anschluss kann sich der Benutzer sofort im System anmelden. Sind Sie sicher, dass Sie den Benutzer anlegen möchten?</p>
            </div>
        </div>


        <div class="alert alert-danger">
            <div class="alertIcon">
                <i class="far fa-exclamation-circle"></i>
            </div>
            <div>
                Diese Aktion kann nicht rückgängig gemacht werden.
            </div>
        </div>
    </div>
</div>



<footer>
    <div class="form-group row align-items-center">
        <div class="col-6 text-left">
            <button type="button" id="closeListEditorButton" class="btn btn-secondary">
                Abbrechen
            </button>
        </div>

        <div class="col-6 text-right">
            <button type="submit" class="btn btn-primary">
                Benutzer <?php echo e($username); ?> erstellen
            </button>
        </div>
    </div>
</footer>


<script>
    // Abbrechen-Button
    // Muss hier extra deklariert werden, weil dieses Template asynchron via Ajax ausgeliefert wird und der DOM bereits
    // aufgebaut und geladen ist
    jQuery("#closeUserListEditorButton").click(function () {
        jQuery("#closeUserListEditor").trigger("click");
    });
</script>

<?php echo BootForm::close(); ?><?php /**PATH E:\Projekte\KTK\ktkmouldtec\resources\views/operator/newUserConfirm.blade.php ENDPATH**/ ?>