<?php
use App\Http\Controllers\UserController;
?>

<?php $__env->startSection('content'); ?>
    <main class="contentContainer">

        <h1>Projektvariablen</h1>
        <div class="row">
            <div class="col-12 col-md-3 text-md-center">
                <?php if(UserController::checkRight("createVariable", $user)): ?>
                    <a class="button editVariable"
                       href="#"
                       data-variableid="0">Neue Projektvariable anlegen</a>
                <?php endif; ?>
            </div>



        </div>

        <div class="clearfix">&nbsp;</div>

        <div class="row no-gutters" data-itable='1'>
            <div class="col-12">
                <div class="row no-gutters listHeader">
                    <div class="col-4">
                        Bezeichnung
                    </div>
                    <div class="col-4">
                        Bezeichnung im Dokument
                    </div>
                    <div class="col-2">
                        Variablentyp
                    </div>
                    <div class="col-2">
                        Aktionen
                    </div>
                </div>
                <div class="listBody">
                <?php if(count($variableList) > 0): ?>
                    <?php $__currentLoopData = $variableList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $variable): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="row no-gutters align-items-center listItem">

                            <div class="col-4 label">
                                <?php echo e($variable->title); ?>

                            </div>

                            <div class="col-4">
                                <?php echo e($variable->variable_title); ?>

                            </div>

                            <div class="col-2">
                                <?php echo e($variable->type); ?>

                            </div>

                            <div class="col-2">
                                <div class="row no-gutters">
                                    <div class="">
                                        <?php if(UserController::checkRight("editVariable", $user)): ?>
                                            <a href="#"
                                               data-variableid="<?php echo e($variable->id); ?>"
                                               class="editVariable"
                                               title="Bearbeiten">
                                                <i class="fal fa-pencil-alt"></i>
                                            </a>
                                        <?php endif; ?>
                                    </div>

                                    <div class="">
                                        <?php if(UserController::checkRight("deleteVariable", $user)): ?>
                                            <a href="#"
                                               data-variableid="<?php echo e($variable->id); ?>"
                                               class="deleteVariable"
                                               title="Löschen">
                                                <i class="fal fa-trash-alt"></i>
                                            </a>
                                        <?php endif; ?>
                                    </div>

                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                <?php else: ?>
                    <div id="noListEntries" class="row">
                        <div class="col-12 text-center">
                            Keine Variablen für Projekte hinterlegt.
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </main>
    <div id="article-variable">

    </div>
    <?php echo $__env->make('layouts.overlay', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


    <script>

        jQuery(function () {
            // Variable anlegen/bearbeiten: Overlay öffnen
            jQuery(".editVariable").click(function () {
                showLoadingSpinner();

                // Ajax-Parameter festlegen
                var url = '/variable';
                var data = {};
                data["variableId"] = jQuery(this).data("variableid");
                data["ref_type"] = "project";

                // Handling für erfolgreichen Request
                successFunction = function (response) {
                    if (response.response == "success") {
                        jQuery("#loadingSpinner").hide();
                        jQuery("#editorContent").html(response.editorHTML);
                        jQuery("#listEditor").addClass("windowNarrow");
                        jQuery("#listEditor").fadeIn();
                    }
                    else {
                        errorFunction(response);
                    }
                };

                // Handling für fehlerhaften Request
                errorFunction = function (response) {
                    showModalBox("Es ist ein Fehler aufgetreten.", response.message);
                    hideLoadingSpinner();
                };

                // Ajax aufrufen
                fireAjax(url, data, successFunction, errorFunction);
            });


            // Auftragstyp löschen: Overlay öffnen
            jQuery(".deleteVariable").click(function () {
                showLoadingSpinner();

                // Ajax-Parameter festlegen
                var url = '/conf/variables/deleteConfirm';
                var data = {};
                data["variableId"] = jQuery(this).data("variableid");

                // Handling für erfolgreichen Request
                successFunction = function (response) {
                    if (response.response == "success") {
                        jQuery("#loadingSpinner").hide();
                        jQuery("#editorContent").html(response.editorHTML);
                        jQuery("#listEditor").addClass("windowModal");
                        jQuery("#listEditor").fadeIn();
                    }
                    else {
                        errorFunction(response);
                    }
                };

                // Handling für fehlerhaften Request
                errorFunction = function (response) {
                    showModalBox("Es ist ein Fehler aufgetreten.", response.message);
                    hideLoadingSpinner();
                };

                // Ajax aufrufen
                fireAjax(url, data, successFunction, errorFunction);

            });

        });
    </script>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\Projekte\KTK\ktkmouldtec\resources\views/variables/projectVariables/list.blade.php ENDPATH**/ ?>