<?php

use App\Library\Dropzone;

# Dropzone initialisieren
$hasImage = 0;
if ($userToEdit->image != null) {
    $hasImage = 1;
}

$dropzoneOptions = array(
    "thumbnailWidth" => 93,
    "thumbnailHeight" => 93,
);

$dropzone = new Dropzone($dropzoneOptions,
    "userEdit",
    "userImageDropzone",
    "default",
    true, $userToEdit->getImage());
?>

<header>Profil bearbeiten</header>

<div class="container">
    <div class="row no-gutters align-items-center">
        <div class="col-md-3">
            <?php
            echo $dropzone->getDropzoneForm();
            ?>
        </div>
        <div class="col-md-5">
            <div class="row userName">
                <?php echo e($userToEdit->getName()); ?>

            </div>
            <div class="row userEmail">
                <?php echo e($userToEdit->email); ?>

            </div>
        </div>
    </div>

    <div class="row spacer-vertical mt-4 mb-5"></div>

    <div class="row no-gutters">
        <div class="col-md-11">
            <?php echo BootForm::open(["id" => "userEdit",
                               "route" => array('user.edit.update', $userToEdit->id),
                               "method" => "POST",
                               "enctype" => "multipart/form-data"]);; ?>


            <input type="hidden" name="deleteFile" id="deleteFile" value="0">


            <input type="hidden" name="newFile" class="newFile" value="">

            <div class="form-group row">
                <label for="name" class="col-md-2 col-form-label">Name</label>
                <div class="col-md-10">
                    <input type="text" class="form-control" id="name" name="name" value="<?php echo e($userToEdit->name); ?>">
                </div>
            </div>

            <div class="form-group row">
                <label for="firstname" class="col-md-2 col-form-label">Vorname</label>
                <div class="col-md-10">
                    <input type="text" class="form-control" id="firstname" name="firstname"
                           value="<?php echo e($userToEdit->firstname); ?>">
                </div>
            </div>

            <div class="form-group row">
                <label for="firstname" class="col-md-2 col-form-label">E-Mail</label>
                <div class="col-md-10">
                    <input type="text" class="form-control" id="email" name="email"
                           value="<?php echo e($userToEdit->email); ?>">
                </div>
            </div>

        </div>
    </div>
</div>

<footer>
    <div class="form-group row align-items-center">
        <div class="col-6 text-left">
            <button type="button" id="closeListEditorButton" class="btn btn-secondary">
                Abbrechen
            </button>
        </div>

        <div class="col-6 text-right">
            <button type="submit" form="userEdit" class="btn btn-primary">
                Speichern
            </button>
        </div>
    </div>
</footer>

<?php
echo $dropzone->getDropzoneJSCode();
?>

<?php echo BootForm::close();; ?>




<?php if(isset($validator)): ?>
    <script type="text/javascript" src="<?php echo e(asset('vendor/jsvalidation/js/jsvalidation.js')); ?>"></script>
    <?php if(is_array($validator)): ?>
        <?php $__currentLoopData = $validator; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vali): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php echo $vali; ?>

        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php else: ?>
        <?php echo $validator; ?>

    <?php endif; ?>
<?php endif; ?>
