<?php

use App\Http\Controllers\UserController;

if ($orderType->id == NULL) $mode = "create";
else $mode = "edit";

?>

<header>Auftragstyp <?php if($mode=="create"): ?> anlegen <?php elseif($mode=="edit"): ?> bearbeiten <?php endif; ?></header>


<div class="container">
    <?php if($mode=="create"): ?>
        <?php echo BootForm::open(["id" => "editOrderType",
                             "route" => "orderTypes.store",
                             "method" => "POST",
                             "enctype" => "multipart/form-data"]);; ?>

    <?php elseif($mode=="edit"): ?>
        <?php echo BootForm::open(["id" => "editOrderType",
                             "route" => array("orderTypes.update", $orderType->id),
                             "method" => "POST",
                             "enctype" => "multipart/form-data"]);; ?>

    <?php endif; ?>


    <div class="form-group row">
        <label for="label" class="col-12 col-lg-4 col-form-label">Auftragstyp</label>
        <div class="col-12 col-lg-8">
            <input type="text" class="form-control" id="label" name="label"
                   value="<?php echo e($orderType->label); ?>">
        </div>
    </div>

    <div class="form-group row">
        <label for="order_statuses_id" class="col-12 col-lg-4 col-form-label">Startstatus</label>
        <div class="col-12 col-lg-8">
            <select class="form-control" name="order_statuses_id" id="order_statuses_id">
                <?php $__currentLoopData = $orderStatusList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $orderStatus): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if($mode == "edit" && $orderStatus->id == $orderType->order_statuses_id): ?>
                        <option value="<?php echo e($orderStatus->id); ?>" selected><?php echo e($orderStatus->label); ?></option>
                    <?php else: ?>
                        <option value="<?php echo e($orderStatus->id); ?>"><?php echo e($orderStatus->label); ?></option>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>
    </div>
</div>

<footer>
    <div class="form-group row align-items-center">
        <div class="col-6 text-left">
            <button type="button" id="closeListEditorButton" class="btn btn-secondary">
                Abbrechen
            </button>
        </div>

        <div class="col-6 text-right">
            <button type="submit" form="editOrderType" class="btn btn-primary">
                Speichern
            </button>
        </div>
    </div>
</footer>

<?php echo BootForm::close(); ?>




<?php if(isset($validator)): ?>
    <script type="text/javascript" src="<?php echo e(asset('vendor/jsvalidation/js/jsvalidation.js')); ?>"></script>
    <?php if(is_array($validator)): ?>
        <?php $__currentLoopData = $validator; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vali): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php echo $vali; ?>

        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php else: ?>
        <?php echo $validator; ?>

    <?php endif; ?>
<?php endif; ?>
<?php /**PATH E:\Projekte\KTK\ktkmouldtec\resources\views/order_conf/order_types/edit.blade.php ENDPATH**/ ?>