<?php echo BootForm::open(["id" => "deleteProject",
                   "route" => array('projects.delete'),
                   "method" => "POST",
                   "enctype" => "multipart/form-data"]); ?>

<div>
    <header>Projekt löschen</header>

    <div class="container">

        <div class="row">
            <div class="col-md-12">
                <p>Sind Sie sich sicher, dass Sie das Projekt mit der Nummer <strong><?php echo e($project->project_nr); ?></strong> löschen möchten?</p>
                <p><strong>Kunde: </strong> <?php echo e($project->customerName); ?></p>
                <p><strong>Projekttyp: </strong> <?php echo e($project->project_type_title); ?></p>
            </div>
        </div>


        <div class="row align-items-center">
            <div class="col-md-10">
                Bitte bestätigen Sie das Löschen, indem Sie die Checkbox aktivieren.
                <input type="hidden" name="projectToDelete" value="<?php echo e($project->id); ?>">
            </div>

            <div class="col-md-2">
                <label class="toggleCheckbox">
                    <input type="checkbox" name="confirmDelete">
                    <i class="bigger"></i>
                </label>
            </div>
        </div>


        <div class="alert alert-danger">
            <div class="alertIcon">
                <i class="far fa-exclamation-circle"></i>
            </div>
            <div>
                Diese Aktion kann nicht rückgängig gemacht werden.
            </div>
        </div>
    </div>
</div>



<footer>
    <div class="form-group row align-items-center">
        <div class="col-6 text-left">
            <button type="button" id="closeListEditorButton" class="btn btn-secondary">
                Abbrechen
            </button>
        </div>

        <div class="col-6 text-right">
            <button type="submit" class="btn btn-primary">
                Projekt #<?php echo e($project->id); ?> löschen
            </button>
        </div>
    </div>
</footer>

<?php echo BootForm::close(); ?><?php /**PATH E:\Projekte\KTK\ktkmouldtec\resources\views/project/deleteProject.blade.php ENDPATH**/ ?>