<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\UserController;
use App\User;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Foundation\Auth\RegistersUsers;

use JsValidator;
use View;

class RegisterController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Register Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles the registration of new users as well as their
    | validation and creation. By default this controller uses a trait to
    | provide this functionality without requiring any additional code.
    |
    */

    use RegistersUsers;

    /**
     * Where to redirect users after registration.
     *
     * @var string
     */
    protected $redirectTo = '/home';

    protected $registerValidationRules;

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest');

        $userController = new UserController();
        $arr = ['password' => 'required|string|min:6|confirmed'];
        $this->registerValidationRules = array_merge($arr, $userController->getRegisterValidationRules());

    }

    # Standardmethode aus Trait überschrieben, um Validierung ins Registrierungsformular einzubauen
    public function showRegistrationForm()
    {
        $frontValidator = JsValidator::make($this->registerValidationRules, [], [], "#registerForm");
        return View::make('auth.register')->with(["validator" => $frontValidator]);
    }

    /**
     * Get a validator for an incoming registration request.
     *
     * @param  array  $data
     * @return \Illuminate\Contracts\Validation\Validator
     */
    protected function validator(array $data)
    {
        return Validator::make($data, $this->registerValidationRules);
    }

    /**
     * Create a new user instance after a valid registration.
     *
     * @param  array  $data
     * @return \App\User
     */
    protected function create(array $data)
    {
        return User::create([
            'name' => $data['name'],
            'firstname' => $data['firstname'],
            'email' => $data['email'],
            'password' => Hash::make($data['password']),
        ]);
    }

    public function getValidationRules() {
        return $this->registerValidationRules;
    }
}
