<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use Illuminate\Support\Facades\Auth;
use App\User;
use App\Client;
use App\Operator;
use App\Orders;
use App\Customer;
use Carbon\Carbon;
use Illuminate\Support\Facades\View;
use Symfony\Component\HttpFoundation\StreamedResponse;
use Illuminate\Support\Facades\Log;
use App\OrderStatus;

class ControllingController extends Controller {

    public function index() {

        $loggedUser = User::find(Auth::user()->id);

        # Berechtigung prüfen
        if (!UserController::checkRight("seeControlling", $loggedUser))
            return redirect()->route('index');

        $filterParameters = OrdersController::getParametersForOrdersList($loggedUser);

        return View::make('controlling.list')->with($filterParameters);
    }

    public function monthlyIndex() {

        $loggedUser = User::find(Auth::user()->id);

        # Berechtigung prüfen
        if (!UserController::checkRight("seeControlling", $loggedUser))
            return redirect()->route('index');

        $hideFilters["date"] = true;
        $hideFilters["end_date"] = true;

        # Für Filterung alle Auftragstypen etc. laden
        $filterParameters = OrdersController::getParametersForOrdersList($loggedUser);

        $parameters = array_merge(["hideFilters" => $hideFilters], $filterParameters);

        return View::make('controlling.listMonthly')->with($parameters);
    }

    public function export() {
        $loggedUser = User::find(Auth::user()->id);

        # Berechtigung prüfen
        if (!UserController::checkRight("seeControlling", $loggedUser))
            return redirect()->route('index');

        $parameters = [];
        return View::make('controlling.export')->with($parameters);
    }

    public function exportCsv($customerId, $monthFrom, $yearFrom, $monthTo, $yearTo) {
        $loggedUser = User::find(Auth::user()->id);

        # Berechtigung prüfen
        if (!UserController::checkRight("seeControlling", $loggedUser))
            return redirect()->route('index');

        $customer = Customer::find($customerId);
        $filename = "Export_" . $customer->company . "_" . $yearFrom . str_pad($monthFrom, 2, "0", STR_PAD_LEFT) . "-" . $yearTo . str_pad($monthTo, 2, "0", STR_PAD_LEFT) . ".csv";
        $filename = str_replace (" ", "_", $filename); // Firefox Header Fix

        $dateFrom = Carbon::createFromDate($yearFrom, $monthFrom, 1);
        $dateTo = Carbon::createFromDate($yearTo, $monthTo, 1);
        $dateTo->endOfMonth();

        $orders = Orders::where("customer_id", "=", $customerId)
            ->where("client_id", "=", $loggedUser->client->id)
            ->where("export_date", ">=", $dateFrom)
            ->where("export_date", "<=", $dateTo)
            ->whereIn("order_status_id", array(4,7)) // Bei Bau erledigt oder abgeschlossen
            ->get();

        //$orders = Orders::all();

        $columns = array("ANR", "KLS", "Auftrag", "Ansprechpartner", "Anschrift", "Ort", "Erledigt", "Wohneinheiten", "Bearbeiter", "Gutschrift", "Nr.", "Datum", "Betrag");

        return new StreamedResponse(
            function () use ($orders, $columns, $customerId, $monthFrom, $yearFrom, $monthTo, $yearTo) {
                $handle = fopen('php://output', 'w');

                $monthsDe = ["Januar", "Feburar", "März", "April", "Mai", "Juni", "Juli", "August", "September", "Oktober", "November", "Dezember"];
                $customer = Customer::find($customerId);

                // Header ausgeben
                fputcsv($handle, array("PK GmbH"));

                $data = array_map("utf8_decode", array($customer->company));
                fputcsv($handle, $data);

                if ($monthFrom == $monthTo && $yearFrom == $yearTo) {
                    // Beispielsweise "Februar 2019"
                    fputcsv($handle, array("Monat " . $monthsDe[$monthFrom - 1] . " " . $yearFrom));
                }
                else {
                    // Beispielsweise "Februar 2019 bis März 2020"
                    fputcsv($handle, array($monthsDe[$monthFrom - 1] . " " . $yearFrom . " bis " . $monthsDe[$monthTo - 1] . " " . $yearTo));
                }

                // Spaltennamen ausgeben
                fputcsv($handle, $columns, ";");


                $gesamtbetrag = 0;
                $gesamtwohneinheiten = 0;
                // Auftragsdetails ausgeben
                foreach ($orders as $order) {

                    $iCreditNotesPerOrder = 0;

                    foreach ($order->creditNotes as $creditNote) {

                        $iCreditNotesPerOrder++;

                        // ANR Auftragsnummer
                        $anr = $order->order_number;

                        //KLS
                        $kls = "";
                        // Prüfung, ob KLS Feld vorhanden ist
                        $klsFields = $order->order_tags->where("id", "=", 2);
                        if ($klsFields != null && count($klsFields) == 1) {
                            $kls = $klsFields->first()->pivot->tag_value;
                        }
                        //Auftrag bzw. Abrufnr
                        $abrufnr = $creditNote->fetch_number;

                        //Ansprechpartner
                        $ansprechpartner = "";
                        //Anschrift des Hausbesitzers
                        $anschrift = "";
                        //Ort zur Adresse
                        $ort = "";
                        // Erste Adresse zum Auftrag laden
                        $adress = $order->addresses->first();
                        if ($adress != null) {
                            $ansprechpartner = $adress->firstname . " " . $adress->name;
                            $anschrift = $adress->street . " " . $adress->house_number;
                            $ort = $adress->zipcode . " ". $adress->place;
                        }

                        //Erledigt
                        $erledigt = Carbon::createFromTimeString($order->end_date)->format("d.m.Y");
                        //Wohneinheiten zum Auftragstyp
                        $wohneinheiten = $order->apartment_units;
                        //Bearbeiter, ggf. Mehrfachauswahl
                        $bearbeiter = "1";

                        //Gutschrift, Datum des Eingangs -> Mehrfachauswahl
                        $datumgutschrift1 = "";
                        if ($creditNote->date != null)
                            $datumgutschrift1 = Carbon::createFromTimeString($creditNote->date)->format("d.m.Y");
                        //Nr der Gutschriften
                        $gutschriftnr = $creditNote->credit_note_number;
                        //Datum, Gutschrift auf Konto
                        $datumgutschrift2 = "";
                        if ($creditNote->end_date != null)
                            $datumgutschrift2 = Carbon::createFromTimeString($creditNote->end_date)->format("d.m.Y");
                        //Betrag der Gutschrift
                        $betrag = $creditNote->credit_note_value;

                        $gesamtbetrag += $betrag;

                        $gesamtwohneinheiten += $wohneinheiten;

                        $data = array(
                            $anr,
                            $kls,
                            $abrufnr,
                            $ansprechpartner,
                            $anschrift,
                            $ort,
                            $erledigt,
                            $wohneinheiten,
                            $bearbeiter,
                            $datumgutschrift1,
                            $gutschriftnr,
                            $datumgutschrift2,
                            str_replace('.', ',', $betrag)
                        );

                        $data = array_map("utf8_decode", $data);
                        fputcsv($handle, $data, ";");
                    }

                    if($iCreditNotesPerOrder == 0)
                    {
                        // Zum Auftrag wurde überhaupt noch keine Zahlung eingetragen, dieser soll dennoch dargestellt werden

                        // ANR Auftragsnummer
                        $anr = $order->order_number;

                        //KLS
                        $kls = "";
                        // Prüfung, ob KLS Feld vorhanden ist
                        $klsFields = $order->order_tags->where("id", "=", 2);
                        if ($klsFields != null && count($klsFields) == 1) {
                            $kls = $klsFields->first()->pivot->tag_value;
                        }

                        // Leere felder aufgrund fehlender Zahlungs-Datensätze
                        $abrufnr = "";
                        $datumgutschrift1 = "";
                        $gutschriftnr = "";
                        $datumgutschrift2 = "";
                        $betrag = 0;

                        //Ansprechpartner
                        $ansprechpartner = "";
                        //Anschrift des Hausbesitzers
                        $anschrift = "";
                        //Ort zur Adresse
                        $ort = "";
                        // Erste Adresse zum Auftrag laden
                        $adress = $order->addresses->first();
                        if ($adress != null) {
                            $ansprechpartner = $adress->firstname . " " . $adress->name;
                            $anschrift = $adress->street . " " . $adress->house_number;
                            $ort = $adress->zipcode . " ". $adress->place;
                        }

                        //Erledigt
                        $erledigt = Carbon::createFromTimeString($order->end_date)->format("d.m.Y");
                        //Wohneinheiten zum Auftragstyp
                        $wohneinheiten = $order->apartment_units;
                        //Bearbeiter, ggf. Mehrfachauswahl
                        $bearbeiter = "1";

                        $gesamtwohneinheiten += $wohneinheiten;

                        $data = array(
                            $anr,
                            $kls,
                            $abrufnr,
                            $ansprechpartner,
                            $anschrift,
                            $ort,
                            $erledigt,
                            $wohneinheiten,
                            $bearbeiter,
                            $datumgutschrift1,
                            $gutschriftnr,
                            $datumgutschrift2,
                            str_replace('.', ',', $betrag)
                        );
                        $data = array_map("utf8_decode", $data);
                        fputcsv($handle, $data, ";");
                    }
                }
                // Gesamtbetrag ausgeben
                fputcsv($handle, array("", "", "", "", "", "", "", "", "", "", "", "Gesamt Gutschriften:", str_replace('.', ',', $gesamtbetrag)), ";");

                // Gesamtwohneinheiten ausgeben
                fputcsv($handle, array("", "", "", "", "", "", "", "", "", "", "", "Gesamt Wohneinheiten:", $gesamtwohneinheiten), ";");

                fclose($handle);
            },
            200,
            [
                "Content-type" => "text/csv",
                "Content-Disposition" => "attachment; filename=" . $filename,
                "Pragma" => "no-cache",
                "Cache-Control" => "must-revalidate, post-check=0, pre-check=0",
                "Expires" => "0"
            ]
        );
    }

    public function exportCsvOrderstate($orderstateId, $dateFrom, $dateTo) {
        $loggedUser = User::find(Auth::user()->id);

        # Berechtigung prüfen
        if (!UserController::checkRight("seeControlling", $loggedUser))
            return redirect()->route('index');

        $orderstate = OrderStatus::find($orderstateId);
        $filename = "Export_" . $orderstate->label . "_" . $dateFrom . "-" . $dateTo . ".csv";
        $filename = str_replace (" ", "_", $filename); // Firefox Header Fix

        $dateFrom_ToSearch = date("Y-m-d", strtotime($dateFrom))." 00:00:00";
        $dateTo_ToSearch = date("Y-m-d", strtotime($dateTo))." 23:59:59";

        $orders = Orders::where("order_status_id", "=", $orderstateId)
            ->where("client_id", "=", $loggedUser->client->id)
            ->where("export_date", ">=", $dateFrom_ToSearch)
            ->where("export_date", "<=", $dateTo_ToSearch)
            ->get();

        $columns = array("ANR", "KLS", "Auftrag", "Ansprechpartner", "Anschrift", "Ort", "Erledigt", "Wohneinheiten", "Bearbeiter", "Gutschrift", "Nr.", "Datum", "Betrag");

        return new StreamedResponse(
            function () use ($orders, $columns, $orderstateId, $dateFrom, $dateTo) {
                $handle = fopen('php://output', 'w');

                $monthsDe = ["Januar", "Feburar", "März", "April", "Mai", "Juni", "Juli", "August", "September", "Oktober", "November", "Dezember"];
                $orderstate = OrderStatus::find($orderstateId);

                // Header ausgeben
                fputcsv($handle, array("PK GmbH"));

                $data = array_map("utf8_decode", array($orderstate->label));
                fputcsv($handle, $data);

                fputcsv($handle, array($dateFrom . " bis " . $dateTo));

                // Spaltennamen ausgeben
                fputcsv($handle, $columns, ";");


                $gesamtbetrag = 0;
                $gesamtwohneinheiten = 0;
                // Auftragsdetails ausgeben
                foreach ($orders as $order) {

                    $iCreditNotesPerOrder = 0;

                    foreach ($order->creditNotes as $creditNote) {

                        $iCreditNotesPerOrder++;

                        // ANR Auftragsnummer
                        $anr = $order->order_number;

                        //KLS
                        $kls = "";
                        // Prüfung, ob KLS Feld vorhanden ist
                        $klsFields = $order->order_tags->where("id", "=", 2);
                        if ($klsFields != null && count($klsFields) == 1) {
                            $kls = $klsFields->first()->pivot->tag_value;
                        }
                        //Auftrag bzw. Abrufnr
                        $abrufnr = $order->fetch_number;

                        //Ansprechpartner
                        $ansprechpartner = "";
                        //Anschrift des Hausbesitzers
                        $anschrift = "";
                        //Ort zur Adresse
                        $ort = "";
                        // Erste Adresse zum Auftrag laden
                        $adress = $order->addresses->first();
                        if ($adress != null) {
                            $ansprechpartner = $adress->firstname . " " . $adress->name;
                            $anschrift = $adress->street . " " . $adress->house_number;
                            $ort = $adress->zipcode . " ". $adress->place;
                        }

                        //Erledigt
                        $erledigt = Carbon::createFromTimeString($order->end_date)->format("d.m.Y");
                        //Wohneinheiten zum Auftragstyp
                        $wohneinheiten = $order->apartment_units;
                        //Bearbeiter, ggf. Mehrfachauswahl
                        $bearbeiter = "1";

                        //Gutschrift, Datum des Eingangs -> Mehrfachauswahl
                        $datumgutschrift1 = "";
                        if ($creditNote->date != null)
                            $datumgutschrift1 = Carbon::createFromTimeString($creditNote->date)->format("d.m.Y");
                        //Nr der Gutschriften
                        $gutschriftnr = $creditNote->credit_note_number;
                        //Datum, Gutschrift auf Konto
                        $datumgutschrift2 = "";
                        if ($creditNote->end_date != null)
                            $datumgutschrift2 = Carbon::createFromTimeString($creditNote->end_date)->format("d.m.Y");
                        //Betrag der Gutschrift
                        $betrag = $creditNote->credit_note_value;

                        $gesamtbetrag += $betrag;

                        $gesamtwohneinheiten += $wohneinheiten;

                        $data = array(
                            $anr,
                            $kls,
                            $abrufnr,
                            $ansprechpartner,
                            $anschrift,
                            $ort,
                            $erledigt,
                            $wohneinheiten,
                            $bearbeiter,
                            $datumgutschrift1,
                            $gutschriftnr,
                            $datumgutschrift2,
                            str_replace('.', ',', $betrag)
                        );

                        $data = array_map("utf8_decode", $data);
                        fputcsv($handle, $data, ";");
                    }

                    if($iCreditNotesPerOrder == 0)
                    {
                        // Zum Auftrag wurde überhaupt noch keine Zahlung eingetragen, dieser soll dennoch dargestellt werden

                        // ANR Auftragsnummer
                        $anr = $order->order_number;

                        //KLS
                        $kls = "";
                        // Prüfung, ob KLS Feld vorhanden ist
                        $klsFields = $order->order_tags->where("id", "=", 2);
                        if ($klsFields != null && count($klsFields) == 1) {
                            $kls = $klsFields->first()->pivot->tag_value;
                        }

                        // Leere felder aufgrund fehlender Zahlungs-Datensätze
                        $abrufnr = "";
                        $datumgutschrift1 = "";
                        $gutschriftnr = "";
                        $datumgutschrift2 = "";
                        $betrag = 0;

                        //Ansprechpartner
                        $ansprechpartner = "";
                        //Anschrift des Hausbesitzers
                        $anschrift = "";
                        //Ort zur Adresse
                        $ort = "";
                        // Erste Adresse zum Auftrag laden
                        $adress = $order->addresses->first();
                        if ($adress != null) {
                            $ansprechpartner = $adress->firstname . " " . $adress->name;
                            $anschrift = $adress->street . " " . $adress->house_number;
                            $ort = $adress->zipcode . " ". $adress->place;
                        }

                        //Erledigt
                        $erledigt = Carbon::createFromTimeString($order->end_date)->format("d.m.Y");
                        //Wohneinheiten zum Auftragstyp
                        $wohneinheiten = $order->apartment_units;
                        //Bearbeiter, ggf. Mehrfachauswahl
                        $bearbeiter = "1";

                        $gesamtwohneinheiten += $wohneinheiten;

                        $data = array(
                            $anr,
                            $kls,
                            $abrufnr,
                            $ansprechpartner,
                            $anschrift,
                            $ort,
                            $erledigt,
                            $wohneinheiten,
                            $bearbeiter,
                            $datumgutschrift1,
                            $gutschriftnr,
                            $datumgutschrift2,
                            str_replace('.', ',', $betrag)
                        );
                        $data = array_map("utf8_decode", $data);
                        fputcsv($handle, $data, ";");
                    }
                }
                // Gesamtbetrag ausgeben
                fputcsv($handle, array("", "", "", "", "", "", "", "", "", "", "", "Gesamt Gutschriften:", str_replace('.', ',', $gesamtbetrag)), ";");

                // Gesamtwohneinheiten ausgeben
                fputcsv($handle, array("", "", "", "", "", "", "", "", "", "", "", "Gesamt Wohneinheiten:", $gesamtwohneinheiten), ";");

                fclose($handle);
            },
            200,
            [
                "Content-type" => "text/csv",
                "Content-Disposition" => "attachment; filename=" . $filename,
                "Pragma" => "no-cache",
                "Cache-Control" => "must-revalidate, post-check=0, pre-check=0",
                "Expires" => "0"
            ]
        );
    }

    public function exportCsvOperator($operatorId, $dateFrom, $dateTo) {
        $loggedUser = User::find(Auth::user()->id);

        # Berechtigung prüfen
        if (!UserController::checkRight("seeControlling", $loggedUser))
            return redirect()->route('index');

        $operator = Operator::find($operatorId);
        $operatorFullName = $operator->name.' '.$operator->firstname.' '.($operator->company!=null?'('.$operator->company.')':'');
        $filename = "Export_" . $operatorFullName . "_" . $dateFrom . "-" . $dateTo . ".csv";
        $filename = str_replace (" ", "_", $filename); // Firefox Header Fix

        $dateFrom_ToSearch = date("Y-m-d", strtotime($dateFrom))." 00:00:00";
        $dateTo_ToSearch = date("Y-m-d", strtotime($dateTo))." 23:59:59";

        $orders = Orders::join('order_operators', 'order_operators.order_id', '=', 'orders.id')
            ->where("order_operators.operator_id", "=", $operatorId)
            ->where("client_id", "=", $loggedUser->client->id)
            ->where("export_date", ">=", $dateFrom_ToSearch)
            ->where("export_date", "<=", $dateTo_ToSearch)
            ->get();

        $columns = array("ANR", "KLS", "Auftrag", "Ansprechpartner", "Anschrift", "Ort", "Erledigt", "Wohneinheiten", "Bearbeiter", "Gutschrift", "Nr.", "Datum", "Betrag");

        return new StreamedResponse(
            function () use ($orders, $columns, $operatorId, $dateFrom, $dateTo) {
                $handle = fopen('php://output', 'w');

                $monthsDe = ["Januar", "Feburar", "März", "April", "Mai", "Juni", "Juli", "August", "September", "Oktober", "November", "Dezember"];
                $operator = Operator::find($operatorId);

                // Header ausgeben
                fputcsv($handle, array("PK GmbH"));

                $data = array_map("utf8_decode", array($operator->name.' '.$operator->firstname.' '.($operator->company!=null?'('.$operator->company.')':'')));
                fputcsv($handle, $data);

                fputcsv($handle, array($dateFrom . " bis " . $dateTo));

                // Spaltennamen ausgeben
                fputcsv($handle, $columns, ";");


                $gesamtbetrag = 0;
                $gesamtwohneinheiten = 0;
                // Auftragsdetails ausgeben
                foreach ($orders as $order) {

                    $iCreditNotesPerOrder = 0;

                    foreach ($order->creditNotes as $creditNote) {

                        $iCreditNotesPerOrder++;

                        // ANR Auftragsnummer
                        $anr = $order->order_number;

                        //KLS
                        $kls = "";
                        // Prüfung, ob KLS Feld vorhanden ist
                        $klsFields = $order->order_tags->where("id", "=", 2);
                        if ($klsFields != null && count($klsFields) == 1) {
                            $kls = $klsFields->first()->pivot->tag_value;
                        }
                        //Auftrag bzw. Abrufnr
                        $abrufnr = $order->fetch_number;

                        //Ansprechpartner
                        $ansprechpartner = "";
                        //Anschrift des Hausbesitzers
                        $anschrift = "";
                        //Ort zur Adresse
                        $ort = "";
                        // Erste Adresse zum Auftrag laden
                        $adress = $order->addresses->first();
                        if ($adress != null) {
                            $ansprechpartner = $adress->firstname . " " . $adress->name;
                            $anschrift = $adress->street . " " . $adress->house_number;
                            $ort = $adress->zipcode . " ". $adress->place;
                        }

                        //Erledigt
                        $erledigt = Carbon::createFromTimeString($order->end_date)->format("d.m.Y");
                        //Wohneinheiten zum Auftragstyp
                        $wohneinheiten = $order->apartment_units;
                        //Bearbeiter, ggf. Mehrfachauswahl
                        $bearbeiter = "1";

                        //Gutschrift, Datum des Eingangs -> Mehrfachauswahl
                        $datumgutschrift1 = "";
                        if ($creditNote->date != null)
                            $datumgutschrift1 = Carbon::createFromTimeString($creditNote->date)->format("d.m.Y");
                        //Nr der Gutschriften
                        $gutschriftnr = $creditNote->credit_note_number;
                        //Datum, Gutschrift auf Konto
                        $datumgutschrift2 = "";
                        if ($creditNote->end_date != null)
                            $datumgutschrift2 = Carbon::createFromTimeString($creditNote->end_date)->format("d.m.Y");
                        //Betrag der Gutschrift
                        $betrag = $creditNote->credit_note_value;

                        $gesamtbetrag += $betrag;

                        $gesamtwohneinheiten += $wohneinheiten;

                        $data = array(
                            $anr,
                            $kls,
                            $abrufnr,
                            $ansprechpartner,
                            $anschrift,
                            $ort,
                            $erledigt,
                            $wohneinheiten,
                            $bearbeiter,
                            $datumgutschrift1,
                            $gutschriftnr,
                            $datumgutschrift2,
                            str_replace('.', ',', $betrag)
                        );

                        $data = array_map("utf8_decode", $data);
                        fputcsv($handle, $data, ";");
                    }

                    if($iCreditNotesPerOrder == 0)
                    {
                        // Zum Auftrag wurde überhaupt noch keine Zahlung eingetragen, dieser soll dennoch dargestellt werden

                        // ANR Auftragsnummer
                        $anr = $order->order_number;

                        //KLS
                        $kls = "";
                        // Prüfung, ob KLS Feld vorhanden ist
                        $klsFields = $order->order_tags->where("id", "=", 2);
                        if ($klsFields != null && count($klsFields) == 1) {
                            $kls = $klsFields->first()->pivot->tag_value;
                        }

                        // Leere felder aufgrund fehlender Zahlungs-Datensätze
                        $abrufnr = "";
                        $datumgutschrift1 = "";
                        $gutschriftnr = "";
                        $datumgutschrift2 = "";
                        $betrag = 0;

                        //Ansprechpartner
                        $ansprechpartner = "";
                        //Anschrift des Hausbesitzers
                        $anschrift = "";
                        //Ort zur Adresse
                        $ort = "";
                        // Erste Adresse zum Auftrag laden
                        $adress = $order->addresses->first();
                        if ($adress != null) {
                            $ansprechpartner = $adress->firstname . " " . $adress->name;
                            $anschrift = $adress->street . " " . $adress->house_number;
                            $ort = $adress->zipcode . " ". $adress->place;
                        }

                        //Erledigt
                        $erledigt = Carbon::createFromTimeString($order->end_date)->format("d.m.Y");
                        //Wohneinheiten zum Auftragstyp
                        $wohneinheiten = $order->apartment_units;
                        //Bearbeiter, ggf. Mehrfachauswahl
                        $bearbeiter = "1";

                        $gesamtwohneinheiten += $wohneinheiten;

                        $data = array(
                            $anr,
                            $kls,
                            $abrufnr,
                            $ansprechpartner,
                            $anschrift,
                            $ort,
                            $erledigt,
                            $wohneinheiten,
                            $bearbeiter,
                            $datumgutschrift1,
                            $gutschriftnr,
                            $datumgutschrift2,
                            str_replace('.', ',', $betrag)
                        );
                        $data = array_map("utf8_decode", $data);
                        fputcsv($handle, $data, ";");
                    }
                }
                // Gesamtbetrag ausgeben
                fputcsv($handle, array("", "", "", "", "", "", "", "", "", "", "", "Gesamt Gutschriften:", str_replace('.', ',', $gesamtbetrag)), ";");

                // Gesamtwohneinheiten ausgeben
                fputcsv($handle, array("", "", "", "", "", "", "", "", "", "", "", "Gesamt Wohneinheiten:", $gesamtwohneinheiten), ";");

                fclose($handle);
            },
            200,
            [
                "Content-type" => "text/csv",
                "Content-Disposition" => "attachment; filename=" . $filename,
                "Pragma" => "no-cache",
                "Cache-Control" => "must-revalidate, post-check=0, pre-check=0",
                "Expires" => "0"
            ]
        );
    }

    public function exportCsvCredit($dateFrom, $dateTo) {
        $loggedUser = User::find(Auth::user()->id);

        # Berechtigung prüfen
        if (!UserController::checkRight("seeControlling", $loggedUser))
            return redirect()->route('index');

        $filename = "Export_" . "Credit" . "_" . $dateFrom . "-" . $dateTo . ".csv";
        $filename = str_replace (" ", "_", $filename); // Firefox Header Fix

        $dateFrom_ToSearch = date("Y-m-d", strtotime($dateFrom))." 00:00:00";
        $dateTo_ToSearch = date("Y-m-d", strtotime($dateTo))." 23:59:59";

        $orders = Orders::where("client_id", "=", $loggedUser->client->id)
            ->where("export_date", ">=", $dateFrom_ToSearch)
            ->where("export_date", "<=", $dateTo_ToSearch)
            ->get();

        $columns = array("ANR", "KLS", "Auftrag", "Ansprechpartner", "Anschrift", "Ort", "Erledigt", "Wohneinheiten", "Bearbeiter", "Gutschrift", "Nr.", "Datum", "Betrag");

        return new StreamedResponse(
            function () use ($orders, $columns, $dateFrom, $dateTo) {
                $handle = fopen('php://output', 'w');

                $monthsDe = ["Januar", "Feburar", "März", "April", "Mai", "Juni", "Juli", "August", "September", "Oktober", "November", "Dezember"];

                // Header ausgeben
                fputcsv($handle, array("PK GmbH"));

                $data = array_map("utf8_decode", array('Gutschriften'));
                fputcsv($handle, $data);

                fputcsv($handle, array($dateFrom . " bis " . $dateTo));

                // Spaltennamen ausgeben
                fputcsv($handle, $columns, ";");


                $gesamtbetrag = 0;
                $gesamtwohneinheiten = 0;
                // Auftragsdetails ausgeben
                foreach ($orders as $order) {

                    $iCreditNotesPerOrder = 0;

                    foreach ($order->creditNotes as $creditNote) {

                        $iCreditNotesPerOrder++;

                        // ANR Auftragsnummer
                        $anr = $order->order_number;

                        //KLS
                        $kls = "";
                        // Prüfung, ob KLS Feld vorhanden ist
                        $klsFields = $order->order_tags->where("id", "=", 2);
                        if ($klsFields != null && count($klsFields) == 1) {
                            $kls = $klsFields->first()->pivot->tag_value;
                        }
                        //Auftrag bzw. Abrufnr
                        $abrufnr = $order->fetch_number;

                        //Ansprechpartner
                        $ansprechpartner = "";
                        //Anschrift des Hausbesitzers
                        $anschrift = "";
                        //Ort zur Adresse
                        $ort = "";
                        // Erste Adresse zum Auftrag laden
                        $adress = $order->addresses->first();
                        if ($adress != null) {
                            $ansprechpartner = $adress->firstname . " " . $adress->name;
                            $anschrift = $adress->street . " " . $adress->house_number;
                            $ort = $adress->zipcode . " ". $adress->place;
                        }

                        //Erledigt
                        $erledigt = Carbon::createFromTimeString($order->end_date)->format("d.m.Y");
                        //Wohneinheiten zum Auftragstyp
                        $wohneinheiten = $order->apartment_units;
                        //Bearbeiter, ggf. Mehrfachauswahl
                        $bearbeiter = "1";

                        //Gutschrift, Datum des Eingangs -> Mehrfachauswahl
                        $datumgutschrift1 = "";
                        if ($creditNote->date != null)
                            $datumgutschrift1 = Carbon::createFromTimeString($creditNote->date)->format("d.m.Y");
                        //Nr der Gutschriften
                        $gutschriftnr = $creditNote->credit_note_number;
                        //Datum, Gutschrift auf Konto
                        $datumgutschrift2 = "";
                        if ($creditNote->end_date != null)
                            $datumgutschrift2 = Carbon::createFromTimeString($creditNote->end_date)->format("d.m.Y");
                        //Betrag der Gutschrift
                        $betrag = $creditNote->credit_note_value;

                        $gesamtbetrag += $betrag;

                        $gesamtwohneinheiten += $wohneinheiten;

                        $data = array(
                            $anr,
                            $kls,
                            $abrufnr,
                            $ansprechpartner,
                            $anschrift,
                            $ort,
                            $erledigt,
                            $wohneinheiten,
                            $bearbeiter,
                            $datumgutschrift1,
                            $gutschriftnr,
                            $datumgutschrift2,
                            str_replace('.', ',', $betrag)
                        );

                        $data = array_map("utf8_decode", $data);
                        fputcsv($handle, $data, ";");
                    }
                }
                // Gesamtbetrag ausgeben
                fputcsv($handle, array("", "", "", "", "", "", "", "", "", "", "", "Gesamt Gutschriften:", str_replace('.', ',', $gesamtbetrag)), ";");

                // Gesamtwohneinheiten ausgeben
                fputcsv($handle, array("", "", "", "", "", "", "", "", "", "", "", "Gesamt Wohneinheiten:", $gesamtwohneinheiten), ";");

                fclose($handle);
            },
            200,
            [
                "Content-type" => "text/csv",
                "Content-Disposition" => "attachment; filename=" . $filename,
                "Pragma" => "no-cache",
                "Cache-Control" => "must-revalidate, post-check=0, pre-check=0",
                "Expires" => "0"
            ]
        );
    }
}
