<?php

namespace App\Http\Controllers;

use App\User;
use App\Client;
use Illuminate\Support\Facades\Storage;
use App\Operator;
use App\OperatorCalendar;
use App\OrderAppointmentOperator;
use App\OrderAddresses;
use Illuminate\Support\Facades\View;

use DateTime;
use Request;

class OperatorCalendarController extends Controller {
    private $operatorValidationRules = [
    ];


    /**
     * Display a listing of the resource.
     */
    public function index($id) {
        /*
          $loggedUser = User::find(Auth::user()->id);

          # Berechtigung prüfen
          if (!UserController::isClientAdmin($loggedUser) && !UserController::checkRight("seeOperatorList", $loggedUser))
              return redirect()->route('index');

          # Zugehörigen Mandanten bestimmen
          $clientID = $loggedUser->client->id;
          $client = Client::find($clientID);
          if (!$client)
              return redirect()->route('index')->withErrors("Kein Mandant zugeordnet.");

          # Bearbeiter auslesen, die zu diesem Mandanten gehören
          $operatorList = $client->operator;
          */
        return View::make('operatorcalendar.list')->with(["operatorId" => $id]);
    }

    public function summary() {
        return View::make('operatorcalendar.summary');
    }

    // Handelt im Frontend die Anfrage eines neuen Calenders ab
    protected function requestCalendar() {

        $month = request()->input('month');
        $year = request()->input('year');
        $operator_id = request()->input('operator_id');
        $operator = Operator::find($operator_id);

        $html = OperatorCalendarController::getCalendar($operator, $year, $month);

        return response()->json(['response' => 'success', 'html' => $html]);
    }

    // Handelt im Frontend die Anfrage einer neuen Calender-Summary ab
    protected function requestCalendarSummary() {
        $month = request()->input('month');
        $year = request()->input('year');
        $client_id = request()->input('client_id');
        $callback = request()->input('callback');

        $html = OperatorCalendarController::getSummaryCalendar($client_id, $year, $month, $callback);

        return response()->json(['response' => 'success', 'html' => $html]);
    }

    protected function summarylayer() {
        $callback = request()->input('callback');

        // Aktueller Monat und Jahr
        $jahr = Date("Y");
        $monat = Date("n");

        // TODO Dynamischen Mandanten übergeben. Hier erstmal fest mit Clientid=1
        $cliendId = 1;

        $html = OperatorCalendarController::getSummaryCalendar($cliendId, $jahr, $monat, $callback);

        return $html;
    }

    // Handelt im Frontend die Aktualisierung eines Calendar-Status ab
    protected function updateOperatorCalendar() {
        $status = request()->input('status');
        $day = request()->input('day');
        $operator_id = request()->input('operator_id');
        $operator = Operator::find($operator_id);

        $calendarEntry = OperatorCalendar::where('operator_id', $operator->id)->whereDate('datescheduled', "=", date('Y-m-d', $day))->get();
        if ($calendarEntry != null && $calendarEntry->count()) {
            $calendarEntry->first()->delete();
        }

        if ($status != 0) {
            $calendarNew = new OperatorCalendar();
            $calendarNew->operator_id = $operator_id;
            $calendarNew->datescheduled = date('Y-m-d', $day);
            $calendarNew->operator_calendar_status_id = $status;
            $calendarNew->save();
        }
        return response()->json(['response' => 'success']);
    }

    // Handelt im Frontend die Aktualisierung eines Termins (Appointments) ab
    protected function updateAppointmentOperator() {
        $appointmentId = request()->input('appointment_id');
        $day = request()->input('day');
        $operatorId = request()->input('operator_id');
        $operator = Operator::find($operatorId);

        $orderAppointmentOperator = OrderAppointmentOperator::where('id', $appointmentId)->get();
        if ($orderAppointmentOperator != null && $orderAppointmentOperator->count()) {
            $orderAppointmentOperator = $orderAppointmentOperator->first();
            $orderAppointmentOperator->appointment_from = date('Y-m-d', $day);;
            $orderAppointmentOperator->save();
        }
        return response()->json(['response' => 'success']);
    }

    public static function getSummaryCalendar($cliendId, $year, $month, $callback = "") {
        $html = "";

        // Alle Mitarbeiter zum Mandanten listen
        $operators = Operator::where("client_id", 1)->get();
        if ($operators->count()) {

            // TODO besser lösen - deutsche Bezeichnungen
            $wochentage = ["Mo", "Di", "Mi", "Do", "Fr", "Sa", "So"];
            $monate = ["Januar", "Feburar", "März", "April", "Mai", "Juni", "Juli", "August", "September", "Oktober", "November", "Dezember"];

            // Zeitstrahl für Monat erstellen
            $firstDayInMonth = ((new DateTime())->setDate($year, $month, 1))->setTime(0, 0);
            $dayCountInMonth = date("t", $firstDayInMonth->getTimestamp());//28 bis 31

            $html .= '<div class="calendar_area_summary" data-callback="' . $callback . '">';// DIV calendar_area_summary start

            // Header mit Monatstitel und -Navigation
            $html .= '<div class="calendarheader static timelineheader" data-calendar-year="' . $year . '" data-calendar-month="' . $month . '" data-calendar-client="' . $cliendId . '">';
            $html .= '<div class="calendarheader_inner">';
            // Aktuelles Jahr nur ausgeben, wenn dies ungleich dem aktuellen Jahr ist
            if ($year != Date("Y"))
                $html .= '<span class="month_title">' . $monate[$month - 1] . ' ' . $year . '</span>';
            else
                $html .= '<span class="month_title">' . $monate[$month - 1] . '</span>';

            $html .= '<i data-action="next" class="fas fa-chevron-right"></i>';
            $html .= '<i data-action="previous" class="fas fa-chevron-left"></i>';
            // Datum etc als static Bereich
            //---------------------------------------------------------------------
            $html .= '<div style="overflow:hidden;width:100%;">';
                $html .= '<div class="table" style="width:auto;float:right;margin-bottom:0px;">';
                $html .= '<div class="tr">';
                for ($day = 1; $day <= $dayCountInMonth; $day++) {
                    // Bestimmen, ob es sich um ein Wochenende handelt
                    $weekend = (date('N', strtotime($year . "-" . $month . "-" . $day)) >= 6);
                    $html .= '<div style="text-align:center;" class="td specialwidth daytitle' . ($weekend ? " weekend" : "") . '">' . $day . '</div>';
                }
                $html .= '</div>';
                $html .= '</div>';
            $html .= '</div>';
            //---------------------------------------------------------------------

            $html .= '</div>';
            $html .= '</div>';

            $html .= '<div class="table timeline">';
            $html .= '<div class="tr">';
            $html .= '<div class="td">';

            // Part I
            foreach ($operators as $operator) {
                // Neuer Mitarbeiter

                // Bildpfad
                $path = $operator->getImage();

                $html .= '  <div data-facility-group="1" class="objectpreview">';
                $html .= '    <a href="/operator/calendar/'.$operator->id.'">';
                $html .= '      <div class="image" style="background-image:url(' . $path . ');">';
                $html .= '      </div>';
                $html .= '      <div class="description">';
                $html .= $operator->name . ' ' . $operator->firstname;
                $html .= '      </div>';
                $html .= '    </a>';
                $html .= '  </div>';
            }
            $html .= '</div>';// TD 1 schließen

            $html .= '<div class="td">';
            // Alle Zeitstränge untereinander
            $html .= '<div class="innertablescrollframe">';

            $html .= '<div class="table">';
            /*
            $html .= '<div class="tr">';
            for ($day = 1; $day <= $dayCountInMonth; $day++) {
                // Bestimmen, ob es sich um ein Wochenende handelt
                $weekend = (date('N', strtotime($year . "-" . $month . "-" . $day)) >= 6);
                $html .= '<div class="td daytitle' . ($weekend ? " weekend" : "") . '">' . $day . '</div>';
            }
            $html .= '</div>';
            */


            // Part II
            foreach ($operators as $operator) {
                $html .= '<div class="tr">';
                // Tage zum Mitarbeiter
                for ($day = 1; $day <= $dayCountInMonth; $day++) {
                    // Bestimmen, ob es sich um ein Wochenende handelt
                    $weekend = (date('N', strtotime($year . "-" . $month . "-" . $day)) >= 6);

                    $html .= '<div class="td day"><div class="innerday' . ($weekend ? " weekend" : "") . '">';

                    $dataControlling = " data-select-day='" . mktime(0, 0, 0, $month, $day, $year) . "'";
                    $dataControlling .= " data-select-operator='" . $operator->id . "'";
                    $dataControlling .= " data-select-operatorname='" . $operator->name . " " . $operator->firstname . "'"; # Zum Vorblenden in Liste

                    // Prüfen, ob und wieviele Termine an diesem Tag vorliegen
                    $calendarAppointments = OrderAppointmentOperator::where('operator_id', $operator->id)->whereDate('appointment_from', "=", date($year . "-" . $month . "-" . $day))->get();
                    $cntAppointments = $calendarAppointments->count();

                    // Prüfen, ob ein Status (Krankheit oder Urlaub vorliegt)
                    $calendarEntry = OperatorCalendar::where('operator_id', $operator->id)->whereDate('datescheduled', "=", date($year . "-" . $month . "-" . $day))->get();
                    $html .= '<span ' . $dataControlling . ' ';
                    if ($calendarEntry != null && $calendarEntry->count()) {
                        // Wenn zugleich Termine an Urlaubs- oder Krankheitstagen vorliegen, so muss ein Hinweis stattfinden
                        $bonusClass = '';
                        if ($cntAppointments > 0)
                            $bonusClass = ' doubleBooking';

                        if ($calendarEntry->first()->operator_calendar_status_id == 1) // Urlaub
                            $html .= 'class="dayVacation' . $bonusClass . '" title="Urlaub">U';
                        else if ($calendarEntry->first()->operator_calendar_status_id == 2) // Krankheit
                            $html .= 'class="dayIllness' . $bonusClass . '" title="Krankheit">K';
                    }
                    else if ($cntAppointments > 0) {
                        if ($cntAppointments == 1) // Singular vs Plural
                            $html .= 'class="dayAppointments" title="' . $cntAppointments . ' Termin">' . $cntAppointments;
                        else
                            $html .= 'class="dayAppointments" title="' . $cntAppointments . ' Termine">' . $cntAppointments;
                    }
                    else {
                        $html .= 'class="dayEmpty">';
                    }
                    $html .= '</span>';

                    $html .= '</div></div>';
                }
                $html .= '</div>';// TR schließen
            }
            $html .= '</div>';// TABLE schließen
            $html .= '</div>';// innertablescrollframe schließen

            $html .= '</div>';// TD 2 schließen

            $html .= '</div>';// TR schließen
            $html .= '</div>';// TABLE schließen

        }
        else {
            $html = "Keine Einträge vorhanden";
        }
        $html .= '</div>';// DIV calendar_area_summary end

        return $html;
    }

    public static function getCalendar(Operator $operator, $year, $month) {
        $html = "";

        // TODO besser lösen - deutsche Bezeichnungen
        $wochentage = ["Mo", "Di", "Mi", "Do", "Fr", "Sa", "So"];
        $monate = ["Januar", "Feburar", "März", "April", "Mai", "Juni", "Juli", "August", "September", "Oktober", "November", "Dezember"];

        // Bestimmen des ersten Wochentages im Monat
        $firstDayInMonth = ((new DateTime())->setDate($year, $month, 1))->setTime(0, 0);
        $dayCountInMonth = date("t", $firstDayInMonth->getTimestamp());//28 bis 31
        $LastDayInMonth = ((new DateTime())->setDate($year, $month, $dayCountInMonth))->setTime(0, 0);

        $wochentagFirstDayInMonth = date("N", $firstDayInMonth->getTimestamp()); //1=montag bis 7=sonntag
        $wochentagLastDayInMonth = date("N", $LastDayInMonth->getTimestamp()); //1=montag bis 7=sonntag

        // Tage aus dem Vormonat bestimmen
        $daysFromMonthBefore = 0;
        if ($wochentagFirstDayInMonth > 1)
            $daysFromMonthBefore = $wochentagFirstDayInMonth - 1;

        // Tage aus dem Folgemonat bestimmen
        $daysFromMonthAfter = 0;
        if ($wochentagLastDayInMonth < 7)
            $daysFromMonthAfter = 7 - $wochentagLastDayInMonth;

        // Gesamttage, die dargestellt werden müssen
        $iDaysToDisplay = $dayCountInMonth + $daysFromMonthBefore + $daysFromMonthAfter;

        // Tage ausgeben. Hierzu den Starttag bestimmen
        $currentDay = $firstDayInMonth->modify("-" . $daysFromMonthBefore . " day");

        // Calenderdaten und Container
        $hash = bin2hex(random_bytes(16));
        $html .= '<div class="calendar_area" data-calendar-id="' . $hash . '" data-calendar-operator-id="' . $operator->id . '" data-calendar-month="' . $month . '" data-calendar-year="' . $year . '">';

        // Header mit Monatstitel und -Navigation
        $html .= '<div class="calendarheader">';
        $html .= '<div class="calendarheader_inner">';
        // Aktuelles Jahr nur ausgeben, wenn dies ungleich dem aktuellen Jahr ist
        if ($year != Date("Y"))
            $html .= '<span class="month_title">' . $monate[$month - 1] . ' ' . $year . '</span>';
        else
            $html .= '<span class="month_title">' . $monate[$month - 1] . '</span>';

        $html .= '<i data-action="next" class="fas fa-chevron-right"></i>';
        $html .= '<i data-action="previous" class="fas fa-chevron-left"></i>';
        $html .= '</div>';
        $html .= '</div>';


        $html .= '<div class="board"></div>';

        $html .= '<div class="table calendar ddboard">';
        $html .= '<div class="tr">';
        // Tagesbezeichnungen ausgeben
        for ($iTitles = 1; $iTitles <= sizeof($wochentage); $iTitles++) {
            $html .= '<div class="td">' . $wochentage[$iTitles - 1] . '</div>';
        }
        $html .= '</div>';
        for ($i = 1; $i <= $iDaysToDisplay; $i++) {
            if ($i % 7 == 1) {
                // Neue Zeile mit je 7 Tagen beginnen
                $html .= '<div class="tr">';
            }

            $html .= '<div class="td">';

            $dayClass = "";
            if ($i <= $daysFromMonthBefore || $i > $dayCountInMonth + $daysFromMonthBefore) {
                // Tag des Vormonats oder Folgemonats
                # TODO klasse bestimmen
                $dayClass = "anothermonth";
            }
            else {
                // Tag des aktuellen Monats
            }

            if ($i % 7 == 6 || $i % 7 == 0) {
                $dayClass .= " weekend";
            }

            // Prüfen, ob ein Status (Krankheit oder Urlaub vorliegt)
            $calendarEntry = OperatorCalendar::where('operator_id', $operator->id)->whereDate('datescheduled', "=", $currentDay)->get();
            if ($calendarEntry != null && $calendarEntry->count()) {
                if ($calendarEntry->first()->operator_calendar_status_id == 1) // Urlaub
                    $dayClass .= " vacation";
                else if ($calendarEntry->first()->operator_calendar_status_id == 2) // Krankheit
                    $dayClass .= " ill";
            }

            $html .= '<div class="board-column regular ' . $dayClass . '" data-board-day="' . $currentDay->getTimestamp() . '" data-board-opearator="' . $operator->id . '">';
            $html .= '<div class="board-column-header">' . date("j", $currentDay->getTimestamp()) . '</div>';
            $html .= '<div class="board-column-content">';

            // Prüfen, ob ein Auftrag an diesem Tag zum Bearbeiter besteht
            $orderAppointmentOperator = OrderAppointmentOperator::where('operator_id', $operator->id)->whereDate('appointment_from', "=", $currentDay)->get();
            if ($orderAppointmentOperator != null && $orderAppointmentOperator->count()) {
                foreach ($orderAppointmentOperator as $appointment) {
                    if($appointment->order == null) continue;

                    $info = '<a href="' . route('orders.edit', ["orderId" => $appointment->orders_id]) . '"><i class="fal fa-folder-open"></i> Auftrag #' . $appointment->order->order_number . '</a>';              // Prüfen, ob eine Adresse hinterlegt ist
                    $orderAddress = OrderAddresses::where('order_id', $appointment->orders_id)->get();
                    if ($orderAddress != null && $orderAddress->count()) {
                        $orderAddress = $orderAddress->first();
                        $info .= "<br>";
                        $info .= $orderAddress->street . " " . $orderAddress->house_number . ", " . $orderAddress->zipcode . " " . $orderAddress->place;
                    }
                    $html .= '<div class="board-item" data-board-appointment="' . $appointment->id . '"><div class="board-item-content"><span>' . $info . '</span></div></div>';
                }
            }

            $html .= '</div>'; //board-column-content
            $html .= '</div>'; // board-column
            $html .= '</div>'; // td
            if ($i % 7 == 0) {
                // Neue Zeile mit je 7 Tagen schließen
                $html .= '</div>'; // tr
            }

            // Für nächsten Schleifendurchgang den Tag um 1 erhöhen
            $currentDay->modify("+1 day");

        }
        $html .= '</div>'; // Schließe table
        $html .= '</div>'; // Schließe calendar_area

        $html .= '<script>startCalendarDragAndDrop();</script>';

        return $html;
    }
}
