<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Orders;

use Illuminate\Support\Facades\DB;

class OrderAppointmentOperatorController extends Controller {

    # Gibt den zeitlich nächsten Termin von/bis zurück sowie den Bearbeiter
    public static function getNextAppointment(Orders $order) {

        if (count($order->operators) < 0) return null;

        $date = new \DateTime();
        $now = $date->format("Y-m-d 00:00:00");

        $nextAppointment = DB::table('order_appointment_operator')
            ->select('*')
            ->where('orders_id', '=', $order->id)
            ->where('appointment_from', '>=', $now)
            ->orderBy('appointment_from')
            ->limit(1)
            ->first();

        return $nextAppointment;
    }

}
