<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\OrderPositions;
use Log;
use Illuminate\Support\Facades\DB;

class OrderPositionsController extends Controller {

    public static function storeNewPosition($orderId, $positionText, $positionValue) {
        $pos = new OrderPositions();
        $pos->order_id = $orderId;
        $pos->position_text = $positionText;
        $pos->position_value = $positionValue;

        try {
            $pos->save();
        } catch (\Exception $e) {
            Log::error($e->getMessage());
            return false;
        }
        return true;
    }

    public static function removeOrderValuePosition($orderId) {
        try {
            $query = DB::table("order_positions")
                ->where("order_id", "=", $orderId)
                ->where("position_text", "=", "Auftragswert")
                ->delete();

        } catch (\Exception $e) {
            Log::error($e->getMessage());
            return false;
        }
        return true;
    }

    public static function convertToDouble($value) {
        # Wert in datenbankkonformes Format umwandeln
        return doubleval(str_replace(',', '.', $value));
    }

}
