<?php

namespace App\Http\Controllers;

use App\OperatingInstruction;
use App\OrderStatus;
use App\OrderTypes;
use Illuminate\Http\Request;

use App\User;
use App\Client;
use App\ProjectType;
use App\ProceduralInstruction;

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\View;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\ProcessUtils;
use JsValidator;

class ProceduralInstructionsController extends Controller {

    private $proceduralInstructionValidationRules = [
        'title' => 'required|string|max:255',
    ];

    /**
     * Display a listing of the resource.
     */
    public function index() {
        $loggedUser = User::find(Auth::user()->id);

        # Berechtigung prüfen
        if (!UserController::checkRight("seeOrderTypes", $loggedUser))
            return redirect()->route('index');

        # Liste aller ProceduralInstructions(Arbeitsanweisungen) laden
        $proceduralInstructionList = ProceduralInstruction::all();

        return View::make('procedural_instruction.list')->with(["proceduralInstructionList" => $proceduralInstructionList]);
    }

    /**
     * Show the form for creating a new resource.
     * Show the form for editing the specified resource.
     *
     */
    public function edit() {
        $loggedUser = User::find(Auth::user()->id);

        $proceduralInstructionId = request()->input('proceduralInstructionId');

        # Neue Arbeitsanweisung erstellen
        if ($proceduralInstructionId == 0) {
            # Berechtigung prüfen
            if (!UserController::checkRight("createOrderTypes", $loggedUser))
                return response()->json(['response' => 'error', 'message' => 'Keine Berechtigung.']);

            $proceduralInstruction = new ProjectType();
        } # Arbeitsanweisung bearbeiten
        else {
            # Berechtigung prüfen
            if (!UserController::checkRight("editOrderTypes", $loggedUser))
                return response()->json(['response' => 'error', 'message' => ' Keine Berechtigung.']);

            # Arbeitsanweisung finden
            $proceduralInstruction = ProceduralInstruction::find($proceduralInstructionId);
            if ($proceduralInstruction == null)
                return response()->json(['response' => 'error', 'message' => 'Arbeitsanweisung nicht gefunden.']);

        }

        # Auftragsstatus auslesen (für Belegung Startstatus)
//        $orderStatusList = $loggedUser->client->order_status;

        # Validierung
        $frontValidator = JsValidator::make($this->proceduralInstructionValidationRules, [], [], "#editProceduralInstruction");

        $arguments = ["proceduralInstruction" => $proceduralInstruction,
            "validator" => $frontValidator,
//            "orderStatusList" => $orderStatusList
        ];

        # View rendern
        $editorHTML = View::make('procedural_instruction.edit')->with($arguments)->render();

        return response()->json(['response' => 'success', 'editorHTML' => $editorHTML]);
    }


    /**
     * Store a newly created resource
     *
     */
    public function store(Request $request) {
        $loggedUser = User::find(Auth::user()->id);

        # Berechtigung prüfen
        if (!UserController::checkRight("createOrderTypes", $loggedUser))
            return redirect()->route('index');

        # Speichern
        $trySave = $this->save($request, $loggedUser->client);
        if ($trySave instanceof ProceduralInstruction)
            return redirect()->route('proceduralinstructions.list')->with("message", "Arbeitsanweisung " . $trySave->title . " wurde erfolgreich angelegt.");
        # Wenn Speichern nicht erfolgreich, enthält $trySave eventuelle Fehlermeldungen, die dem Nutzer angezeigt werden
        else {
            return redirect()->back()->withErrors($trySave);
        }
    }


    /**
     * Update the specified resource
     *
     */
    public function update(Request $request, $proceduralInstructionId) {
        $loggedUser = User::find(Auth::user()->id);

        # Berechtigung prüfen
        if (!UserController::checkRight("editOrderTypes", $loggedUser))
            return redirect()->route('index');

        # Arbeitsanweisung lesen
        $proceduralInstruction = ProceduralInstruction::find($proceduralInstructionId);
        if ($proceduralInstruction == null) {
            return redirect()->back()->withErrors("Arbeitsanweisung nicht gefunden.");
        }

        # Speichern
        $trySave = $this->save($request, $loggedUser->client, $proceduralInstruction);
        if ($trySave instanceof ProceduralInstruction)
            return redirect()->route('proceduralinstructions.list')->with("message", "Arbeitsanweisung " . $proceduralInstruction->title . " wurde erfolgreich gespeichert.");
        # Wenn Speichern nicht erfolgreich, enthält $trySave eventuelle Fehlermeldungen, die dem Nutzer angezeigt werden
        else {
            return redirect()->back()->withErrors($trySave);
        }
    }


    /**
     * Save the specified resource in storage.
     *
     */
    public function save(Request $request, Client $client, ProceduralInstruction $proceduralInstruction = null) {
        if (is_null($proceduralInstruction)) $proceduralInstruction = new ProceduralInstruction();

        # Input validieren
        $backValidator = Validator::make($request->all(), $this->proceduralInstructionValidationRules);

        if ($backValidator->fails()) {
            return $backValidator->errors();
        }

        # Neue Daten setzen
//        $orderType->client_id = $client->id;
        $proceduralInstruction->title = $request->get('title');
//        $orderType->order_statuses_id = $request->get('order_statuses_id');

        # Speichern
        try {
            $proceduralInstruction->save();
        } catch (\Exception $e) {
            Log::error("Fehler beim Speichern der Daten für Arbeitsanweisung " . $proceduralInstruction->title . ", (ID: " . $proceduralInstruction->id . " ), Mandant " .
                $client->id . ": " . $e->getMessage());
            return "Es ist ein Fehler aufgetreten.";
        }

        return $proceduralInstruction;
    }


    public function showDeleteConfirm() {
        $loggedUser = User::find(Auth::user()->id);

        # Berechtigung prüfen
        if (!UserController::checkRight("deleteOrderTypes", $loggedUser))
            return response()->json(['response' => 'error', 'message' => 'Keine Berechtigung.']);

        $proceduralInstructionId = request()->input('proceduralInstructionId');

        # Auftragstyp lesen
        $proceduralInstruction = ProceduralInstruction::find($proceduralInstructionId);
        if ($proceduralInstruction == null)
            return response()->json(['response' => 'error', 'message' => 'Verfahrensanweisung nicht gefunden.']);

        $arguments = ["confItem" => "proceduralInstructions",
            "confItemLabel" => "Verfahrensanweisung",
            "confItemLabelArticle" => "die",
            "additional_info" => "",
            "item" => $proceduralInstruction];

        # View rendern
        $editorHTML = View::make('project_conf.delete')->with($arguments)->render();

        return response()->json(['response' => 'success', 'editorHTML' => $editorHTML]);
    }

    /**
     * Remove the specified resource from storage.
     *
     */
    public function destroy() {
        $loggedUser = User::find(Auth::user()->id);

        # Berechtigung prüfen
        if (!UserController::isClientAdmin($loggedUser) && !UserController::checkRight("deleteOrderTypes", $loggedUser))
            return redirect()->route('index');

        $proceduralInstructionsId = request()->input('proceduralInstructionsId');
        $confirmDelete = request()->input('confirmDelete');

        # Auftragstyp lesen
        $proceduralInstruction = ProceduralInstruction::find($proceduralInstructionsId);
        if ($proceduralInstruction == null)
            return redirect()->back()->withErrors("Verfahrensanweisung nicht gefunden.");

        # Prüfen, ob Checkbox bestätigt ist
        if (!is_null($confirmDelete)) {
            # Auftragstyp löschen - wenn möglich!
            try {
                # Versuchen, zu löschen
                $proceduralInstruction->delete();
            } catch (\Exception $e) {
                # Es kann sein, dass noch Relations zu Auftragskennzeichen (order_tags) oder Aufträgen (orders) bestehen
                Log::error("Fehler beim Löschen der Verfahrensanweisung " . $proceduralInstruction->id . ", Mandant " .
                    $loggedUser->client->id . ": " . $e->getMessage());

                return redirect()->back()->withErrors("Verfahrensanweisung konnte nicht gelöscht werden. Es bestehen noch 
            Verbindungen zu Dokumenten oder anderen Tabellen.");
            }
        }
        else {
            return redirect()->back()->with("message", "Die Verfahrensanweisung wurde nicht gelöscht, da das Löschen bestätigt werden muss!");
        }

        Log::info("Verfahrensanweisung " . $proceduralInstruction->id . ", Mandant " . $loggedUser->client->id . " wurde gelöscht. 
                            (User " . $loggedUser->id . ")");
        return redirect()->route('proceduralinstructions.list')->with("message", "Verfahrensanweisung wurde erfolgreich gelöscht.");
    }
}
