<?php
# ich bin batman.

namespace App\Http\Controllers;

use App\Client;
use App\User;

use App\ClientToken;
use App\Jobs\SendRegisterClientEMailJob;
use App\Mail\RegisterClient;
use Illuminate\Http\Request;
use View;
use Log;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\URL;
use JsValidator;
use Validator;

class SuperAdminController extends Controller {
    private function getRegisterClientValidationRules() {
        return [
            'name' => 'required|string|max:255|unique:clients',
            'email' => 'required|string|email|max:255|unique:users|same:emailAddressConfirm'
        ];
    }

    # View zum Registrieren eines neuen Mandanten anzeigen
    public function showRegisterClient() {

        $user = User::find(Auth::user()->id);

        # Berechtigung prüfen
        if (!UserController::isSuperAdmin($user))
            return redirect()->route('index');

        # Validierung erstellen
        $frontValidator = JsValidator::make($this->getRegisterClientValidationRules(), [], [], "#newClient");

        return View::make('superAdmin.newClient')->with(["validator" => $frontValidator]);
    }

    # Formulardaten des Registrierungsformulars verarbeiten
    public function handleRegisterClientForm() {

        $user = User::find(Auth::user()->id);

        # Berechtigung prüfen
        if (!UserController::isSuperAdmin($user))
            return redirect()->route('index')->withErrors(["Keine Berechtigung."]);

        # Formulardaten validieren
        $backValidator = Validator::make(request()->all(), $this->getRegisterClientValidationRules());

        if ($backValidator->fails())
            return redirect()->back()->withErrors($backValidator->errors());


        # Neuen Mandanten anlegen
        $newClient = new Client();

        $newClient->name = request()->get('name');
        $newClient->firstContactMail = request()->get('email');

        try {
            $newClient->save();
        } catch (\Exception $e) {
            Log::error("Fehler bei Registrierung des neuen Mandanten " . request()->get('clientName') . ": " . $e->getMessage());
            return redirect()->back()->withErrors(["Es ist ein Fehler aufgetreten: ", $e->getMessage()]);
        }

        # Token hinterlegen
        $token = ClientTokenController::generateToken();

        $clientRegisterToken = new ClientToken();
        $clientRegisterToken->client_id = $newClient->id;
        $clientRegisterToken->type = "register";
        $clientRegisterToken->token = ClientTokenController::hashToken($token);
        $clientRegisterToken->creator = "User " . Auth::user()->id;

        try {
            $clientRegisterToken->save();
        } catch (\Exception $e) {
            # Neuen Mandanten wieder entfernen
            $newClient->delete();

            Log::error("Fehler bei Token-Erstellung für neuen Mandanten " . request()->get('clientName') . ": " . $e->getMessage());
            return redirect()->back()->withErrors(["Es ist ein Fehler aufgetreten: ", $e->getMessage()]);
        }

        # E-Mail versenden
        $completeRegisterLink = URL::asset("/client/newClient/" . $token);

        $registerClientMail = new RegisterClient($newClient->name, $completeRegisterLink);

        try {
            $job = new SendRegisterClientEMailJob($newClient->firstContactMail, $registerClientMail);
            dispatch($job)->onQueue('emails');
        } catch (\Exception $e) {
            # Neuen Mandanten wieder entfernen
            $newClient->delete();

            Log::error("Fehler beim Versenden der E-Mail für das Registrieren eines neuen Mandanten");
            Log::error($e->getMessage());
            return redirect()->back()->withErrors(["Es ist ein Fehler aufgetreten."]);
        }

        return redirect()->back()->with("message", "Die E-Mail zur Registrierung eines neuen Mandanten und dessen Administrator wurde versandt.");
    }

}
