<?php

namespace App\Http\Controllers;

use Storage;
use File;
use DateTime;
use Illuminate\Support\Facades\Log;

class UploadController extends Controller {

    public static function renameFile($filename, $newFilename, $path, $newPath) {

        try {
            Storage::disk('uploads')->move($path . $filename,
                $newPath . $newFilename);
        } catch (\Exception $e) {
            Log::error("Umbenennen des Files fehlgeschlagen.");
            Log::error("++ Altes File: " . "app/" . "public/uploads" . $path . $filename);
            Log::error("++ Neues File: " . "app/" . "public/uploads" . $newPath . $newFilename);
            Log::error("Fehler : " . $e->getMessage());
            return false;
        }

        return true;
    }

    public static function copyFile($file, $newFile, $path, $newPath) {
        try {
            Storage::disk('uploads')->copy($path . $file,
                $newPath . $newFile);
        } catch (\Exception $e) {
            Log::error("Kopieren des Files fehlgeschlagen.");
            Log::error("++ Altes File: " . "app/" . "public/uploads" . $path . $file);
            Log::error("++ Neues File: " . "app/" . "public/uploads" . $newPath . $newFile);
            Log::error("Fehler : " . $e->getMessage());
            return false;
        }
        return true;
    }

    public static function tmpFileUpload($uploadFile, $path, $rename = true) {
        if ($rename == true)
            $fileName = "tmp_" . date("Ymd_His") . "_" . uniqid(null, true) .
                "_" . $uploadFile->getClientOriginalName();
        else
            $fileName = $uploadFile->getClientOriginalName();

        if ($uploadFile) {
            $tmpFileName = self::uploadFile($uploadFile, $fileName, $path);

            if (!$tmpFileName) {
                Log::error("Fehler beim Hochladen: " . $tmpFileName);
                return false;
            }
        }
    }

    public static function uploadFile($uploadFile, $fileName, $path) {
        # Datei speichern
        try {
            Storage::disk("uploads")->put($path . "/" . $fileName, File::get($uploadFile));

        } catch (\Exception $e) {
            Log::error("Dateiupload fehlgeschlagen.");
            Log::error("++ Dateiname: " . $fileName);
            Log::error("++ Pfad: " . $path);
            Log::error("Fehler : " . $e->getMessage());

            return false;
        }
        return ($fileName);
    }

    public static function deleteFile($pathFile, $disk = "uploads") {

        # Prüfen, ob Datei existiert
        if (!Storage::disk($disk)->exists($pathFile)) return false;

        # Datei löschen
        try {
            Storage::disk($disk)->delete($pathFile);
        } catch (\Exception $e) {
            Log::error("Fehler beim Löschen einer eigentlich vorhandenen Datei: " . $e->getMessage());
            return false;
        }

        return true;
    }

    public static function cleanUpTmpFiles($path = DropzoneController::DROPZONE_TMP_PATH) {

        Log::info("### Start Aufräumjob - UploadController");
        Log::info("### Pfad: " . $path);

        $storagePath = Storage::disk("uploads")->getDriver()->getAdapter()->getPathPrefix() . $path;

        try {
            $dir = new \DirectoryIterator($storagePath);
        } catch (\Exception $e) {
            Log::error("Fehler beim Öffnen des Verzeichnisses " . storage_path('app/uploads' . $path));
            Log::error($e->getMessage());
            return false;
        }

        # Verzeichnis durchlaufen
        while ($dir->valid()) {
            # Nur Dateien analysieren
            if (!$dir->isDot()) {
                # Prüfen, ob Datei temporär und "liegengeblieben" ist
                $str = substr($dir->current()->getFilename(), 0, 3);


                if ($str == "tmp") {
                    #Erstellungszeit der Datei auslesen
                    $now = new DateTime();

                    $lastModified = filemtime($dir->current()->getPathName());

                    # Alter der Datei berechnen
                    $diff = abs($now->getTimestamp() - $lastModified);

                    $diff = 90000;

                    # Wenn Datei länger als 24h liegt, löschen
                    if ($diff >= 84600) {
                        Storage::disk('uploads')->delete($path . $dir->current()->getFilename());
                    }
                }
            }
            $dir->next();
        }

        Log::info("### Ende Aufräumjob - UploadController");
        return true;
    }

    public static function downloadFile($pathFile) {
        try {
            return response()->download(storage_path("app/public/uploads" . $pathFile));
        } catch (\Exception $e) {
            return abort(404);
        }
    }
}
