<?php
# Bildet eine Dropzone zum Hochladen mehrerer Bilder ab und dient der Generierung von HTML- und JavaScript-Code

namespace App\Library;

use Illuminate\Support\Facades\View;

class DropzoneMulti {
    public $relatedForm;
    public $formID;
    private $route;
    private $dropAnimation;
    private $animationIcon;
    private $dropzoneOptions;

    public $dropzoneName;
    public $documentId;

    public function __construct($dropzoneOptions,
                                $relatedForm,
                                $formID = "anotherDropzone",
                                $route = "default",
                                $dropAnimation = true, $animationIcon = "fas fa-images", $dropzoneName = "newFiles", $documentId = -1) {

        $this->dropzoneOptions = $dropzoneOptions;
        $this->relatedForm = $relatedForm;
        $this->formID = $formID;
        $this->documentId = $documentId;

        $this->dropzoneName = $dropzoneName;

        if ($route == "default") $this->route = "dropzone.uploadTemporaryFile";
        else $this->route = $route;

        $this->dropAnimation = $dropAnimation;

        if ($this->dropAnimation == true) $this->animationIcon = $animationIcon;

        # Dropzone-Optionen festlegen, ggf. Standard-Einstellungen hinzufügen
        if (is_array($dropzoneOptions)) {
            $this->dropzoneOptions = Dropzone::mergeOptions($this->getDefaultOptions(),
                $dropzoneOptions);
        }

        # Übersetzungstexte an Konfiguration anpassen
        $this->dropzoneOptions["dictFileTooBig"] = '"Die Datei ist zu groß. Erlaubte Dateigröße: '.$this->dropzoneOptions["maxFilesize"].' MB."';
        $this->dropzoneOptions["dictMaxFilesExceeded"] = '"Es kann können maximal '.$this->dropzoneOptions["maxFiles"].' Dateien hochgeladen werden."';
        $this->dropzoneOptions["dropzoneName"] = "'".$dropzoneName."'";
        $this->dropzoneOptions["documentId"] = $documentId;
    }

    public function getDropzoneForm() {
        $parameters = array();

        $parameters["formID"] = $this->formID;
        $parameters["route"] = $this->route;
        $parameters["dropAnimation"] = $this->dropAnimation;
        $parameters["animationIcon"] = $this->animationIcon;
        $parameters["dropzoneName"] = $this->dropzoneName;

        $htmlForm = View::make('dropzoneMulti.htmlForm', $parameters);


        return $htmlForm->render();
    }

    private function getDefaultOptions() {
        $defaultOptions = array();

        # Standardeinstellungen
        $defaultOptions["paramName"] = '"uploadFile"';
        $defaultOptions["previewsContainer"] = '"#' . $this->formID . ' .showFilePreview"';
        $defaultOptions["clickable"] = '["#' . $this->formID . ' .uploadContainerMultiple"]';
        $defaultOptions["maxFiles"] = 5;
        $defaultOptions["acceptedFiles"] = '"image/jpg,image/jpeg,image/png,image/gif"';
        $defaultOptions["maxFilesize"] = 1;
        $defaultOptions["thumbnailWidth"] = 140;
        $defaultOptions["thumbnailHeight"] = 140;

        $defaultOptions["addRemoveLinks"] = "true";

        # Standardübersetzungstexte
        $defaultOptions["dictFileTooBig"] = '"Die Datei ist zu groß. Erlaubte Dateigröße: {{maxFilesize}} MB."';
        $defaultOptions["dictMaxFilesExceeded"] = '"Es kann können maximal {{maxFiles}} Dateien hochgeladen werden."';
        $defaultOptions["dictInvalidFileType"] = '"Dieser Dateityp ist nicht erlaubt."';
        $defaultOptions["dictRemoveFile"] = '"<span class=\"removePreviewFileMulti\"><i class=\"fas fa-times-circle fa-2x\"></i></span>"';

        return $defaultOptions;
    }

    public function getDropzoneJSCode() {

        # Parameter setzen
        $parameters = array();
        $parameters["relatedForm"] = $this->relatedForm;
        $parameters["formID"] = $this->formID;
        $parameters["dropAnimation"] = $this->dropAnimation;

        # Einstellungen für die Dropzone in JS-Code umwandeln
        $parameters["options"] = Dropzone::convertToJSArray($this->dropzoneOptions);

        $parameters["dropzoneName"] = $this->dropzoneName;

        $customJS = View::make('dropzoneMulti.customJSCode', $parameters);
        $jsCode = $customJS->render();

        return $jsCode;
    }
}
