<?php

namespace App\Listeners\Auth;

use Illuminate\Auth\Events\Login;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;

use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Auth;

class LogSuccessfulLogin {
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct() {
        //
    }

    /**
     * Handle the event.
     *
     * @param  Login $event
     */
    public function handle(Login $event) {
        # Prüfen, ob der Nutzer einem Mandanten zugeordnet ist
        # Ohne Mandant ist das System nicht nutzbar
        if ($event->user->client_id == 0 || $event->user->client_id == NULL) {
            # Im Fall der Fälle User kommentarlos wieder ausloggen
            Auth::logout();
            # Log schreiben
            Log::error("USER OHNE MANDANTENZUORDNUNG - User-ID: " . $event->user->id);
        }
    }
}
