<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;
use App\User;

class ConfirmClientAdmin extends Mailable
{
    use Queueable, SerializesModels;

    public $user;
    public $clientName;
    public $link;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct(User $user, $clientName, $link)
    {
        $this->user = $user;
        $this->clientName = $clientName;
        $this->link = $link;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->subject("Registrierung Mandantenadministrator " . $this->clientName)
            ->view('mail.confirmClientAdmin');
    }
}
