<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;

class RegisterClient extends Mailable
{
    use Queueable, SerializesModels;

    public $clientName;
    public $subject;
    public $link;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($clientName, $link)
    {
        $this->clientName = $clientName;
        $this->link = $link;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->subject("Registrierung Mandant ". $this->clientName)
            ->view('mail.registerClient');
    }
}
