<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Log;

class NumberRanges extends Model {

    public function getNextNumber($skip = 0) {
        $newNumber = $this->current_number + $skip + 1;

        $this->current_number = $newNumber;

        try {
            $this->save();
        }
        catch(\Exception $e) {
            Log::error("Fehler bei Rausziehen einer Nummer aus Nummernkreis ". $this->id .": ". $e->getMessage());
            return 0;
        }
        return $newNumber;
    }

}
