<?php

namespace App;

use Illuminate\Database\Eloquent\Relations\Pivot;
use Illuminate\Database\Eloquent\SoftDeletes;

use Carbon\Carbon;

class OrderCreditNote extends Pivot {
    use \Askedio\SoftCascade\Traits\SoftCascadeTrait;
    use SoftDeletes;

    protected $table = "order_credit_notes";

    public function getReadableValue() {
        return (str_replace('.', ',', round($this->credit_note_value, 2)));
    }

    public function getReadableDate() {
        if ($this->date <> NULL) {
            $c = Carbon::createFromFormat("Y-m-d H:i:s", $this->date);
            return $c->format("d.m.Y");
        }
        return "";
    }

    public function getReadableEndDate() {
        if ($this->end_date <> NULL) {
            $c = Carbon::createFromFormat("Y-m-d H:i:s", $this->end_date);
            return $c->format("d.m.Y");
        }
        return "";

    }

    # Enddatum Auftrag für Anzeigen formatieren
    public function getEndDateDateString() {
        if ($this->end_date != "") {
            $c = Carbon::createFromFormat("Y-m-d H:i:s", $this->end_date);
            return $c->toDateString();

        }
        else return "";
    }

    public function getDateDateString() {
        if ($this->date != "") {
            $date = $this->date;
        }
        else $date = Carbon::now()->format("Y-m-d H:i:s");

        $c = Carbon::createFromFormat("Y-m-d H:i:s", $date);
        return $c->toDateString();
    }
}
