<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Carbon\Carbon;

class OrderFollowUp extends Model
{
    use \Askedio\SoftCascade\Traits\SoftCascadeTrait;
    use SoftDeletes;

    public function operator() {
        return $this->belongsTo(Operator::class, 'operator_id', 'id');
    }

    public function nextUp() {
        $c = Carbon::createFromFormat('Y-m-d H:i:s', $this->nextUp);
        return $c->format("d.m.Y");
    }

    public function order() {
        return $this->belongsTo(Orders::class, 'order_id', 'id');
    }
}
