<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;

class OrderMailLog extends Model {
    public function operator() {
        return $this->belongsTo(Operator::class);
    }

    public function sentDate() {
        $c = Carbon::createFromFormat('Y-m-d H:i:s', $this->created_at);

        return $c->format("d.m.Y, H:i") . " Uhr";

    }

    # Auszug der E-Mail
    public function messageExcerpt($maxLength) {
        $text = $this->text;

        if (strlen($text) <= $maxLength) {
            return $text;
        }

        if (strlen($text) > $maxLength) {
            $text = substr($text, 0, $maxLength + 1);
            if ($last_space = strrpos($text, ' ')) {
                $text = substr($text, 0, $last_space);
                $text = rtrim($text);
            }
            $text .= '...';
        }

        return $text;
    }
}
