<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class OrderTypes extends Model
{
    # Mandanten zurückgeben
    public function client() {
        return $this->belongsTo(Client::class);
    }

    # Aufträge
    public function orders() {
        return $this->hasMany(Orders::class, "order_type_id");
    }

    # Auftragskennzeichen
    public function order_tags() {
        return $this->hasMany(OrderTags::class);
    }

    # Startstatus des Auftragstyps
    public function order_statuses() {
        return $this->belongsTo(OrderStatus::class);
    }
}
