<?php


namespace App;

use App\Repositories\Interfaces\DocumentRelationInterface;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;


class Project extends Model implements DocumentRelationInterface{
    use SoftDeletes;

    public static $STATUS_DRAFT = "draft";
    public static $STATUS_PENDING = "pending";
    public static $STATUS_CREATED = "created";

    # Kunde
    public function customer() {
        return $this->hasOne(Customer::class, 'id', 'customer_id');
    }

    # ProjektTyp
    public function project_type() {
        return $this->hasOne(ProjectType::class, 'id', 'project_type_id');
    }

    # ProjektTyp
    public function project_operator_responsible() {
        return $this->belongsToMany(Operator::class, 'project_operator_responsible', 'project_id')->orderBy('name');
    }

    public function articles(){
        return $this->hasMany(Article::class);
    }

    public function documents()
    {
        return $this->morphMany(Document::class, 'attachable');
    }

    public function variables(){
        return $this->hasMany(ProjectVariable::class);
    }
}