<?php


namespace App\Repositories;


use PhpOffice\PhpWord\Shared\ZipArchive;

class PowerPointDocumentRepository
{
    protected $docPath;
    protected $zipPath;
    protected $unzipPath;


    public function __construct($docPath)
    {
        $this->docPath = $docPath;
    }

    public function modifyDocument()
    {
        $this->unzip();
        $this->replaceVariables();
        $this->zip();
    }


    private function replaceVariables()
    {

    }

    private function replace_extension($filename, $seperator,$new_extension) {
        $info = pathinfo($filename);
        return $info['dirname']."/".$info['filename'] . $seperator . $new_extension;
    }

    private function unzip()
    {
        $this->zipPath = $this->replace_extension($this->docPath,".", "zip");
        $this->unzipPath = $this->replace_extension($this->docPath, "","");
        copy($this->docPath, $this->zipPath);
        $zip = new ZipArchive();
        $res = $zip->open($this->zipPath);

        if($res === true) {
            mkdir($this->unzipPath);
            $zip->extractTo($this->unzipPath);
            $zip->close();
        }
    }

    private function zip()
    {
        $zip = new ZipArchive();
        $zip->open($this->docPath, ZipArchive::CREATE | ZipArchive::OVERWRITE);

// Initialize empty "delete list"
        $filesToDelete = array();

// Create recursive directory iterator
        /** @var SplFileInfo[] $files */
        $files = new \RecursiveIteratorIterator(
            new \RecursiveDirectoryIterator(realpath($this->unzipPath)),
            \RecursiveIteratorIterator::LEAVES_ONLY
        );

        foreach ($files as $name => $file)
        {
            // Skip directories (they would be added automatically)
            if (!$file->isDir())
            {
                // Get real and relative path for current file
                $filePath = $file->getRealPath();
                $relativePath = substr($filePath, strlen(realpath($this->unzipPath)) + 1);

                // Add current file to archive
                $zip->addFile($filePath, $relativePath);

                // Add current file to "delete list"
                // delete it later cause ZipArchive create archive only after calling close function and ZipArchive lock files until archive created)
//                if ($file->getFilename() != 'important.txt')
//                {
                    $filesToDelete[] = $filePath;
//                }
            }
        }

// Zip archive will be created only after closing object
        $zip->close();

// Delete all files from "delete list"
        foreach ($filesToDelete as $file)
        {
            unlink($file);
        }
    }

}