<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateTextblocksTable extends Migration {
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up() {
        Schema::create('textblocks', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('client_id')->unsigned();

            $table->integer('type')->default(0); # Mögliche Werte siehe Konstanten im Model
            $table->boolean('hasPlaceholders')->default(false); # Textbaustein mit Platzhaltern
            $table->string('subject');
            $table->text('text');

            $table->timestamps();

            $table->foreign('client_id')->references('id')->on('clients')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down() {
        Schema::dropIfExists('textblocks');
    }
}
