<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

use Illuminate\Support\Facades\DB;

class CreateOrderCreditNoteTable extends Migration {
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up() {
        Schema::create('order_credit_notes', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('order_id')->unsigned();

            $table->string('fetch_number');
            $table->timestamp('date')->default(DB::RAW('CURRENT_TIMESTAMP'));
            $table->string('credit_note_number')->default('');
            $table->string('reference_number')->default('');
            $table->double('credit_note_value');
            $table->string('end_date')->default('');

            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down() {
        Schema::dropIfExists('order_credit_notes');
    }
}
