<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class OrderInvoiceAddProjectnameDateserviceprovision extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('order_invoice', function (Blueprint $table) {
            $table->string('project_name')->default('');
            $table->date('service_provision_date')->nullable()->default(NULL);

            # Adressdatenfelder nullbar machen, weil oft Daten beim Auftraggeber nicht vollständig gepflegt sind
            $table->string('street')->nullable()->default('')->change();
            $table->string('house_number')->nullable()->default('')->change();
            $table->string('zipcode')->nullable()->default('')->change();
            $table->string('place')->nullable()->default('')->change();
            $table->string('country')->nullable()->default('')->change();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('order_invoice', function (Blueprint $table) {
            $table->dropColumn(['project_name', 'service_provision_date']);
        });
    }
}
