<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class OrderDocumentsAddLocked extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('order_documents', function (Blueprint $table) {
            $table->integer('user_id')->unsigned()->after('order_id');
            $table->integer('locked')->unsigned()->default(0)->after('user_id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('order_documents', function (Blueprint $table) {
            $table->dropColumn(['user_id']);
            $table->dropColumn(['locked']);
        });
    }
}
