<?php

use Illuminate\Database\Seeder;
use Faker\Factory as Faker;

class OrderAddressesTableSeeder extends Seeder {

    /**
     * Auto generated seed file
     *
     * @return void
     */
    public function run() {

        \DB::table('order_addresses')->delete();

        return;

        $locations[92660] = "Neustadt an der Waldnaab";
        $locations[92637] = "Weiden in der Oberpfalz";
        $locations[92696] = "Floß";
        $locations[92711] = "Parkstein";
        $locations[92706] = "Luhe-Wildenau";
        $locations[92648] = "Vohenstrauß";
        $locations[95700] = "Neusorg";

        $faker = Faker::create("de_DE");
        foreach (range(1, 100) as $index) {

            $zipcode = $faker->randomElement(array_keys($locations));

            DB::table('order_addresses')->insert([
                'address_addendum' => $faker->randomElement(["", "", "", "", $faker->randomElement(["z.Hd.", "c/o", "o.V.i.A"]) . " " . $faker->name]),
                'company' => $faker->randomElement(["", $faker->company]),
                'country' => 'Deutschland',
                'firstname' => $faker->firstname,
                'house_number' => ($faker->numberBetween(1, 99) . $faker->randomElement(["", "a", "b", "c", "d"])),
                'name' => $faker->lastName,
                'note' => $faker->text(30),
                'order_id' => $index,
                'place' => $locations[$zipcode],
                'street' => $faker->streetName,
                'telephone_number' => $faker->phoneNumber,
                'zipcode' => $zipcode,
                'email_final_customer' => $faker->safeEMail,
            ]);
        }

    }
}